/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.ChannelDescription;
import com.gtnewhorizon.structurelib.CommonProxy;
import com.gtnewhorizon.structurelib.ConfigurationHandler;
import com.gtnewhorizon.structurelib.DevelopHelper;
import com.gtnewhorizon.structurelib.GuiHandler;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.block.BlockHint;
import com.gtnewhorizon.structurelib.command.CommandConfigureChannels;
import com.gtnewhorizon.structurelib.command.CommandRegistryDebug;
import com.gtnewhorizon.structurelib.item.ItemBlockHint;
import com.gtnewhorizon.structurelib.item.ItemConstructableTrigger;
import com.gtnewhorizon.structurelib.item.ItemFrontRotationTool;
import com.gtnewhorizon.structurelib.net.AlignmentMessage;
import com.gtnewhorizon.structurelib.net.ErrorHintParticleMessage;
import com.gtnewhorizon.structurelib.net.RegistryOrderSyncMessage;
import com.gtnewhorizon.structurelib.net.SetChannelDataMessage;
import com.gtnewhorizon.structurelib.net.UpdateHintParticleMessage;
import com.gtnewhorizon.structurelib.util.InventoryUtility;
import com.gtnewhorizon.structurelib.util.XSTR;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="structurelib", name="StructureLib", version="1.4.18", acceptableRemoteVersions="*", guiFactory="com.gtnewhorizon.structurelib.GuiFactory")
public class StructureLib {
    private static final String STRUCTURECOMPAT_MODID = "structurecompat";
    public static boolean DEBUG_MODE;
    public static boolean PANIC_MODE;
    public static final Logger LOGGER;
    @SidedProxy(serverSide="com.gtnewhorizon.structurelib.CommonProxy", clientSide="com.gtnewhorizon.structurelib.ClientProxy")
    static CommonProxy proxy;
    static final SimpleNetworkWrapper net;
    public static final XSTR RANDOM;
    @Mod.Instance
    static StructureLib INSTANCE;
    @Mod.Instance(value="structurecompat")
    static Object COMPAT;
    static Block blockHint;
    static Item itemBlockHint;
    static Item itemFrontRotationTool;
    static Item itemConstructableTrigger;
    public static final CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        ConfigurationHandler.INSTANCE.init(e.getSuggestedConfigurationFile());
        blockHint = new BlockHint();
        GameRegistry.registerBlock((Block)blockHint, ItemBlockHint.class, (String)"blockhint");
        itemBlockHint = ItemBlock.func_150898_a((Block)StructureLibAPI.getBlockHint());
        itemFrontRotationTool = new ItemFrontRotationTool();
        GameRegistry.registerItem((Item)itemFrontRotationTool, (String)itemFrontRotationTool.func_77658_a());
        itemConstructableTrigger = new ItemConstructableTrigger();
        GameRegistry.registerItem((Item)itemConstructableTrigger, (String)itemConstructableTrigger.func_77658_a());
        proxy.preInit(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)StructureLib.instance(), (IGuiHandler)new GuiHandler());
        InventoryUtility.init();
        ChannelDescription.set("show_error", "structurelib", "channels.structurelib.show_errors");
        DevelopHelper.onPreInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent e) {
        proxy.loadComplete(e);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandConfigureChannels());
        e.registerServerCommand((ICommand)new CommandRegistryDebug());
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            switch (message.key) {
                case "register_channel": {
                    this.processRegisterChannel(message);
                    break;
                }
                case "register_channel_item": {
                    this.processRegisterChannelItem(message);
                }
            }
        }
    }

    private void processRegisterChannel(FMLInterModComms.IMCMessage message) {
        NBTTagList tags = message.getNBTValue().func_150295_c("Channels", 10);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound tag = tags.func_150305_b(i);
            StructureLibAPI.registerChannelDescription(tag.func_74779_i("Channel"), message.getSender(), tag.func_74779_i("Description"));
        }
    }

    private void processRegisterChannelItem(FMLInterModComms.IMCMessage message) {
        NBTTagList items = message.getNBTValue().func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)itemTag.func_74775_l("Item"));
            NBTTagList tags = itemTag.func_150295_c("Channels", 10);
            for (int j = 0; j < tags.func_74745_c(); ++j) {
                NBTTagCompound tag = tags.func_150305_b(j);
                StructureLibAPI.registerChannelItem(tag.func_74779_i("Channel"), message.getSender(), tag.func_74762_e("Value"), item);
            }
        }
    }

    public static void addClientSideChatMessages(String ... messages) {
        proxy.addClientSideChatMessages(messages);
    }

    public static EntityPlayer getCurrentPlayer() {
        return proxy.getCurrentPlayer();
    }

    public static boolean isCurrentPlayer(EntityPlayer player) {
        return proxy.isCurrentPlayer(player);
    }

    public static long getOverworldTime() {
        return proxy.getOverworldTime();
    }

    public static StructureLib instance() {
        return INSTANCE;
    }

    public CommonProxy proxy() {
        return proxy;
    }

    static {
        PANIC_MODE = Boolean.getBoolean("structurelib.panic");
        LOGGER = LogManager.getLogger((String)"StructureLib");
        net = NetworkRegistry.INSTANCE.newSimpleChannel("structurelib");
        net.registerMessage(AlignmentMessage.ServerHandler.class, AlignmentMessage.AlignmentQuery.class, 0, Side.SERVER);
        net.registerMessage(AlignmentMessage.ClientHandler.class, AlignmentMessage.AlignmentData.class, 1, Side.CLIENT);
        net.registerMessage(UpdateHintParticleMessage.Handler.class, UpdateHintParticleMessage.class, 2, Side.CLIENT);
        net.registerMessage(SetChannelDataMessage.Handler.class, SetChannelDataMessage.class, 3, Side.SERVER);
        net.registerMessage(ErrorHintParticleMessage.Handler.class, ErrorHintParticleMessage.class, 4, Side.CLIENT);
        net.registerMessage(RegistryOrderSyncMessage.Handler.class, RegistryOrderSyncMessage.class, 5, Side.SERVER);
        try {
            DEBUG_MODE = Boolean.parseBoolean(System.getProperty("structurelib.debug"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            DEBUG_MODE = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        }
        RANDOM = new XSTR();
        creativeTab = new CreativeTabs("structurelib"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return StructureLibAPI.getItemBlockHint();
            }
        };
    }
}

