/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment;

import com.gtnewhorizon.structurelib.alignment.AlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraftforge.common.util.ForgeDirection;

public interface IAlignmentLimits {
    public static final IAlignmentLimits UNLIMITED = (direction, rotation, flip) -> true;
    public static final IAlignmentLimits UPRIGHT = (direction, rotation, flip) -> direction.offsetY == 0 && (flip.isVerticallyFliped() ? rotation.isUpsideDown() : rotation.isNotRotated());
    public static final IAlignmentLimits NOT_UPSIDE_DOWN = (direction, rotation, flip) -> direction.offsetY != 0 || (flip.isVerticallyFliped() ? !rotation.isNotRotated() : !rotation.isUpsideDown());
    public static final IAlignmentLimits FACING_UP = (direction, rotation, flip) -> direction == ForgeDirection.UP;

    public boolean isNewExtendedFacingValid(ForgeDirection var1, Rotation var2, Flip var3);

    default public boolean isNewExtendedFacingValid(ExtendedFacing alignment) {
        return this.isNewExtendedFacingValid(alignment.getDirection(), alignment.getRotation(), alignment.getFlip());
    }

    public static IAlignmentLimits allowOnly(ExtendedFacing ... allowedFacings) {
        Builder builder = Builder.denyAll();
        for (ExtendedFacing allowedFacing : allowedFacings) {
            builder.allow(allowedFacing);
        }
        return builder.build();
    }

    public static IAlignmentLimits denyOnly(ExtendedFacing ... allowedFacings) {
        Builder builder = Builder.allowAll();
        for (ExtendedFacing allowedFacing : allowedFacings) {
            builder.deny(allowedFacing);
        }
        return builder.build();
    }

    public static class Builder {
        protected final boolean[] validStates = new boolean[IAlignment.STATES_COUNT];

        private Builder() {
        }

        public static Builder allowAll() {
            Builder b = new Builder();
            Arrays.fill(b.validStates, true);
            return b;
        }

        public static Builder denyAll() {
            Builder b = new Builder();
            Arrays.fill(b.validStates, true);
            return b;
        }

        public Builder deny(ForgeDirection fd) {
            ExtendedFacing.getAllWith(fd).stream().mapToInt(ExtendedFacing::getIndex).forEach(v -> {
                this.validStates[v] = false;
            });
            return this;
        }

        public Builder allow(ForgeDirection fd) {
            ExtendedFacing.getAllWith(fd).stream().mapToInt(ExtendedFacing::getIndex).forEach(v -> {
                this.validStates[v] = true;
            });
            return this;
        }

        public Builder deny(ExtendedFacing o) {
            this.validStates[o.getIndex()] = false;
            return this;
        }

        public Builder allow(ExtendedFacing o) {
            this.validStates[o.getIndex()] = true;
            return this;
        }

        public Builder deny(Rotation fd) {
            ExtendedFacing.getAllWith(fd).stream().mapToInt(ExtendedFacing::getIndex).forEach(v -> {
                this.validStates[v] = false;
            });
            return this;
        }

        public Builder allow(Rotation fd) {
            ExtendedFacing.getAllWith(fd).stream().mapToInt(ExtendedFacing::getIndex).forEach(v -> {
                this.validStates[v] = true;
            });
            return this;
        }

        public Builder deny(Flip fd) {
            ExtendedFacing.getAllWith(fd).stream().mapToInt(ExtendedFacing::getIndex).forEach(v -> {
                this.validStates[v] = false;
            });
            return this;
        }

        public Builder allow(Flip fd) {
            ExtendedFacing.getAllWith(fd).stream().mapToInt(ExtendedFacing::getIndex).forEach(v -> {
                this.validStates[v] = true;
            });
            return this;
        }

        public Builder filter(Function<ExtendedFacing, Optional<Boolean>> predicate) {
            for (ExtendedFacing value : ExtendedFacing.VALUES) {
                predicate.apply(value).ifPresent(bool -> {
                    this.validStates[value.getIndex()] = bool;
                });
            }
            return this;
        }

        public Builder ensureDuplicates() {
            for (ExtendedFacing value : ExtendedFacing.VALUES) {
                if (!this.validStates[value.getIndex()]) continue;
                this.validStates[value.getDuplicate().getIndex()] = true;
            }
            return this;
        }

        public Builder ensureNoDuplicates(Flip flip) {
            if (flip == Flip.BOTH || flip == Flip.NONE) {
                throw new IllegalArgumentException("Preffered Flip must be Horizontal or Vertical");
            }
            flip = flip.getOpposite();
            for (ExtendedFacing value : ExtendedFacing.VALUES) {
                if (!this.validStates[value.getIndex()] || value.getFlip() != Flip.BOTH && value.getFlip() != flip) continue;
                this.validStates[value.getIndex()] = false;
                this.validStates[value.getDuplicate().getIndex()] = true;
            }
            return this;
        }

        public IAlignmentLimits build() {
            return new AlignmentLimits(this.validStates);
        }
    }
}

