/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import cpw.mods.fml.relauncher.Side;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.Certificate;
import java.util.Map;
import net.glease.tc4tweak.CommonProxy;
import net.glease.tc4tweak.network.MessageSendConfiguration;

@Mod(modid="tc4tweak", name="TC4 Tweak", version="1.4.7", dependencies="required-after:Thaumcraft", guiFactory="net.glease.tc4tweak.GuiFactory")
public class TC4Tweak {
    public static final String MOD_ID = "tc4tweak";
    private static final VersionRange ACCEPTED_CLIENT_VERSION = VersionParser.parseRange((String)"[1.2.0-beta1,)");
    private static final ImmutableMap<String, String> KNOWN_SIGNATURE = ImmutableMap.of((Object)"47:3C:3A:39:76:76:97:8F:F4:87:7A:BA:2D:57:86:0D:DA:20:E2:FC", (Object)"glease");
    @Mod.Instance
    public static TC4Tweak INSTANCE;
    @SidedProxy(serverSide="net.glease.tc4tweak.CommonProxy", clientSide="net.glease.tc4tweak.ClientProxy")
    static CommonProxy proxy;
    public final SimpleNetworkWrapper CHANNEL = new SimpleNetworkWrapper("tc4tweak");
    private boolean allowAll = true;

    public TC4Tweak() {
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String getLabel() {
                return "TC4Tweak signing signature";
            }

            public String call() {
                try {
                    Certificate certificate = ((ModContainer)Loader.instance().getIndexedModList().get(TC4Tweak.MOD_ID)).getSigningCertificate();
                    if (certificate == null) {
                        return "None. Do not bother glease for this crash!";
                    }
                    String fingerprint = CertificateHelper.getFingerprint((Certificate)certificate);
                    return fingerprint + ", Built by: " + (String)KNOWN_SIGNATURE.getOrDefault((Object)fingerprint, (Object)"Not known");
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    sw.append("Cannot determine due to error: ");
                    e.printStackTrace(new PrintWriter(sw));
                    return sw.toString();
                }
            }
        });
    }

    void detectAndSendConfigChanges() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            TC4Tweak.INSTANCE.CHANNEL.sendToAll((IMessage)new MessageSendConfiguration());
        }
    }

    void setAllowAll(boolean allowAll) {
        this.allowAll = allowAll;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent e) {
        proxy.serverStarted();
    }

    @NetworkCheckHandler
    public boolean checkConnection(Map<String, String> remoteVersions, Side side) {
        if (side == Side.CLIENT) {
            String remoteVersionString = remoteVersions.getOrDefault(MOD_ID, null);
            return this.allowAll || remoteVersionString != null && ACCEPTED_CLIENT_VERSION.containsVersion((ArtifactVersion)new DefaultArtifactVersion(MOD_ID, remoteVersionString));
        }
        return true;
    }
}

