/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.glease.tc4tweak.ClientProxy;
import net.glease.tc4tweak.ClientUtils;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.modules.researchBrowser.BrowserPaging;
import net.glease.tc4tweak.modules.researchBrowser.DrawResearchBrowserBorders;
import net.minecraft.inventory.IInventory;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.client.gui.GuiResearchTable;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.tiles.TileMagicWorkbench;

public class ASMCallhook {
    private static final WeakHashMap<TileMagicWorkbench, Void> postponed = new WeakHashMap();
    private static final AtomicBoolean cacheUsed = new AtomicBoolean(false);
    private static long lastUpdate = 0L;
    private static boolean priorityChanged = false;

    private ASMCallhook() {
    }

    public static void onCacheLookupHead() {
        cacheUsed.lazySet(true);
    }

    public static void onMappingDidWork() {
        if (!priorityChanged && cacheUsed.get()) {
            Thread.currentThread().setPriority(5);
            priorityChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePostponed() {
        WeakHashMap<TileMagicWorkbench, Void> weakHashMap = postponed;
        synchronized (weakHashMap) {
            for (Map.Entry<TileMagicWorkbench, Void> workbench : postponed.entrySet()) {
                TileMagicWorkbench tile = workbench.getKey();
                if (tile == null || tile.eventHandler == null || tile.func_145837_r() || !tile.func_145830_o()) continue;
                tile.eventHandler.func_75130_a((IInventory)tile);
            }
            postponed.clear();
        }
    }

    public static void handleMouseInput(GuiResearchTable screen) {
        ClientProxy.handleMouseInput(screen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCraftingMatrix(TileMagicWorkbench self) {
        if (!self.func_145831_w().field_72995_K) {
            self.eventHandler.func_75130_a((IInventory)self);
            return;
        }
        long oldUpdate = lastUpdate;
        lastUpdate = System.currentTimeMillis();
        if (lastUpdate - oldUpdate > 200L) {
            self.eventHandler.func_75130_a((IInventory)self);
        } else {
            WeakHashMap<TileMagicWorkbench, Void> weakHashMap = postponed;
            synchronized (weakHashMap) {
                postponed.put(self, null);
            }
        }
    }

    public static void renderFacingStrip(double px, double py, double pz, float angle, float scale, float alpha, int frames, int strip, int frame, float partialTicks, int color) {
        UtilsFX.renderFacingStrip((double)px, (double)py, (double)pz, (float)angle, (float)Math.min(scale, ConfigurationHandler.INSTANCE.getNodeVisualSizeLimit()), (float)alpha, (int)frames, (int)strip, (int)frame, (float)partialTicks, (int)color);
    }

    public static void renderAnimatedQuadStrip(float scale, float alpha, int frames, int strip, int cframe, float partialTicks, int color) {
        UtilsFX.renderAnimatedQuadStrip((float)Math.min(scale, ConfigurationHandler.INSTANCE.getNodeVisualSizeLimit()), (float)alpha, (int)frames, (int)strip, (int)cframe, (float)partialTicks, (int)color);
    }

    public static void drawResearchBrowserBorders(GuiResearchBrowser gui, int x, int y, int u, int v, int width, int height) {
        DrawResearchBrowserBorders.drawResearchBrowserBorders(gui, x, y, u, v, width, height);
    }

    public static void drawResearchBrowserBackground(GuiResearchBrowser gui, int x, int y, int u, int v, int width, int height) {
        DrawResearchBrowserBorders.drawResearchBrowserBackground(gui, x, y, u, v, width, height);
    }

    public static int getResearchBrowserHeight() {
        return ConfigurationHandler.INSTANCE.getBrowserHeight();
    }

    public static int getResearchBrowserWidth() {
        return ConfigurationHandler.INSTANCE.getBrowserWidth();
    }

    public static int getTabDistance() {
        return ConfigurationHandler.INSTANCE.getBrowserWidth() + 8;
    }

    public static int getTabIconDistance() {
        return ConfigurationHandler.INSTANCE.getBrowserWidth() + 24;
    }

    public static int getNewGuiMapTop(int oldVal) {
        return (int)((float)oldVal - 85.0f * (ConfigurationHandler.INSTANCE.getBrowserScale() - 1.0f));
    }

    public static int getNewGuiMapLeft(int oldVal) {
        return (int)((float)oldVal - 112.0f * (ConfigurationHandler.INSTANCE.getBrowserScale() - 1.0f));
    }

    public static int getNewGuiMapBottom(int oldVal) {
        return (int)((float)oldVal - 112.0f * (ConfigurationHandler.INSTANCE.getBrowserScale() - 1.0f));
    }

    public static int getNewGuiMapRight(int oldVal) {
        return (int)((float)oldVal - 61.0f * (ConfigurationHandler.INSTANCE.getBrowserScale() - 1.0f));
    }

    public static int getTabPerSide() {
        return BrowserPaging.getTabPerSide();
    }

    public static LinkedHashMap<String, ResearchCategoryList> getTabsOnCurrentPage(String player) {
        return BrowserPaging.getTabsOnCurrentPage(player);
    }

    public static void drawResearchCategoryHintParticles(int x, int y, int u, int v, int width, int height, double zLevel, GuiResearchBrowser gui) {
        if (x < gui.field_146294_l / 2) {
            UtilsFX.drawTexturedQuad((int)x, (int)y, (int)u, (int)v, (int)width, (int)height, (double)zLevel);
        } else {
            ClientUtils.drawRectTextured(x += 16, x + width, y, y + height, u + width, u, v + height, v, zLevel);
        }
    }
}

