/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class MappingThreadVisitor
extends ClassVisitor {
    public MappingThreadVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("run") && desc.equals("()V")) {
            TC4Transformer.log.debug("Visiting method run()V");
            return new RunVisitor(this.api, mv);
        }
        return mv;
    }

    private static class RunVisitor
    extends MethodVisitor {
        public RunVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitCode() {
            super.visitCode();
            TC4Transformer.log.debug("Injecting thread priority change");
            this.mv.visitMethodInsn(184, "java/lang/Thread", "currentThread", "()Ljava/lang/Thread;", false);
            this.mv.visitInsn(4);
            this.mv.visitMethodInsn(182, "java/lang/Thread", "setPriority", "(I)V", false);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 185 && "java/util/Iterator".equals(owner) && "next".equals(name)) {
                TC4Transformer.log.debug("Injecting callhook before Iterator#next()");
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "onMappingDidWork", "()V", false);
            }
        }
    }
}

