/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.generateItemHash;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;

public class GenerateItemHash {
    private static final int DEFAULT_NAMESPACE_HASH_BASE;
    private static final ConcurrentHashMap<List<?>, int[]> groupedObjectTags;

    private static int updateHash(int hash, int number) {
        return GenerateItemHash.updateHash(hash, Integer.toString(number));
    }

    private static int updateHash(int hash, String later) {
        int length = later.length();
        for (int i = 0; i < length; ++i) {
            hash = hash * 31 + later.charAt(i);
        }
        return hash;
    }

    public static int generateItemHash(Item item, int meta) {
        ItemStack t = new ItemStack(item, 1, meta);
        try {
            if (t.func_77984_f() || !t.func_77981_g()) {
                meta = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Object> key = Arrays.asList(item, meta);
        int[] value = groupedObjectTags.get(key);
        if (value != null) {
            meta = value[0];
        }
        key.set(1, meta);
        if (ThaumcraftApi.objectTags.containsKey(key)) {
            return GenerateItemHash.hash(item, meta, t);
        }
        for (List l : ThaumcraftApi.objectTags.keySet()) {
            String name = ((Item)l.get(0)).func_77658_a();
            if (Item.field_150901_e.func_82594_a(name) != item && Block.field_149771_c.func_82594_a(name) != Block.func_149634_a((Item)item) || !(l.get(1) instanceof int[])) continue;
            int[] range = (int[])l.get(1);
            Arrays.sort(range);
            if (Arrays.binarySearch(range, meta) < 0) continue;
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)item);
            int hash = ui != null ? ui.hashCode() : t.func_77977_a().hashCode();
            hash = hash * 31 + 58;
            for (int r : range) {
                hash = GenerateItemHash.updateHash(hash, r);
            }
            return hash;
        }
        key.set(1, -1);
        if (meta == -1 && !ThaumcraftApi.objectTags.containsKey(key)) {
            for (int i = 0; i < 16; ++i) {
                key.set(1, i);
                if (!ThaumcraftApi.objectTags.containsKey(key)) continue;
                return GenerateItemHash.hash(item, i, t);
            }
        }
        return GenerateItemHash.hash(item, meta, t);
    }

    private static int hash(Item item, int meta, ItemStack t) {
        try {
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)item);
            return GenerateItemHash.updateHash(ui != null ? GenerateItemHash.updateHash(ui.modId.hashCode() * 31 + 58, ui.name) * 31 + 58 : t.func_77977_a().hashCode() * 31 + 58, meta);
        }
        catch (Exception e) {
            return DEFAULT_NAMESPACE_HASH_BASE + meta;
        }
    }

    static {
        ConcurrentHashMap tmp;
        DEFAULT_NAMESPACE_HASH_BASE = "oops:".hashCode() * 31;
        try {
            tmp = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(ThaumcraftApi.class, null, (String[])new String[]{"groupedObjectTags"});
        }
        catch (Exception e) {
            tmp = new ConcurrentHashMap();
        }
        groupedObjectTags = tmp;
    }
}

