/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.researchBrowser;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import net.glease.tc4tweak.ClientUtils;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.modules.researchBrowser.ThaumonomiconIndexSearcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.lib.research.ResearchManager;

public class BrowserPaging {
    public static final int BUTTON_HEIGHT = 8;
    public static final int BUTTON_WIDTH = 24;
    private static final Field fieldPlayer = ReflectionHelper.findField(GuiResearchBrowser.class, (String[])new String[]{"player"});
    private static final int NAVIGATION_BUTTON_Z_LEVEL = -50;
    private static int currentPageIndex;
    private static int maxPageIndex;
    private static LinkedHashMap<String, ResearchCategoryList> currentPageTabs;

    public static int getTabPerSide() {
        return ConfigurationHandler.INSTANCE.getBrowserHeight() / 24;
    }

    private static boolean isEldritchUnlocked(GuiResearchBrowser gui) {
        try {
            return ResearchManager.isResearchComplete((String)((String)fieldPlayer.get(gui)), (String)"ELDRITCHMINOR");
        }
        catch (ReflectiveOperationException ignored) {
            return true;
        }
    }

    private static void updateMaxPageIndex(GuiResearchBrowser gui) {
        int tabsPerPage = BrowserPaging.getTabPerSide() * 2;
        int newMaxPageIndex = (ResearchCategories.researchCategories.size() - (BrowserPaging.isEldritchUnlocked(gui) ? 0 : 1) + tabsPerPage) / tabsPerPage - 1;
        if (newMaxPageIndex != maxPageIndex) {
            maxPageIndex = newMaxPageIndex;
            currentPageIndex = Math.min(currentPageIndex, maxPageIndex);
            currentPageTabs = null;
        }
    }

    public static LinkedHashMap<String, ResearchCategoryList> getTabsOnCurrentPage(String player) {
        if (currentPageTabs == null) {
            int tabsPerPage = BrowserPaging.getTabPerSide() * 2;
            if (currentPageIndex > maxPageIndex) {
                currentPageIndex = 0;
            }
            currentPageTabs = new LinkedHashMap();
            int toSkip = tabsPerPage * currentPageIndex;
            for (Map.Entry e : ResearchCategories.researchCategories.entrySet()) {
                if ("ELDRITCH".equals(e.getKey()) && !ResearchManager.isResearchComplete((String)player, (String)"ELDRITCHMINOR")) continue;
                if (toSkip > 0) {
                    --toSkip;
                    continue;
                }
                currentPageTabs.put((String)e.getKey(), (ResearchCategoryList)e.getValue());
                if (currentPageTabs.size() != tabsPerPage) continue;
                break;
            }
        }
        return currentPageTabs;
    }

    static void nextPage() {
        int tabsPerPage = BrowserPaging.getTabPerSide() * 2;
        currentPageIndex = Math.min(currentPageIndex + 1, (ResearchCategories.researchCategories.size() + tabsPerPage) / tabsPerPage - 1);
        currentPageTabs = null;
    }

    static void prevPage() {
        currentPageIndex = Math.max(currentPageIndex - 1, 0);
        currentPageTabs = null;
    }

    public static void init() {
        EventHandler eventHandler = new EventHandler();
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
    }

    public static void flushCache() {
        currentPageTabs = null;
    }

    public static class EventHandler {
        private int ticks;
        private boolean updated = false;

        @SubscribeEvent
        public void onClientTickEnd(TickEvent.ClientTickEvent e) {
            if (e.phase == TickEvent.Phase.START) {
                ++this.ticks;
                this.updated = false;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onGuiInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
            if (e.gui instanceof GuiResearchBrowser && ConfigurationHandler.INSTANCE.isInferBrowserScale()) {
                int searchAreaSizeTimesTwo = ConfigurationHandler.INSTANCE.isInferBrowserScaleConsiderSearch() ? ThaumonomiconIndexSearcher.getResultDisplayAreaWidth(e.gui) * 2 : 0;
                ConfigurationHandler.INSTANCE.setBrowserScale(Math.max(1.0f, Math.min(((float)e.gui.field_146294_l - 32.0f - (float)searchAreaSizeTimesTwo - (float)(24 * Math.min(2, ResearchCategories.researchCategories.size() / BrowserPaging.getTabPerSide()))) / 256.0f, ((float)e.gui.field_146295_m - 34.0f) / 230.0f)));
            }
        }

        @SubscribeEvent
        public void onGuiInitPost(GuiScreenEvent.InitGuiEvent.Post e) {
            if (e.gui instanceof GuiResearchBrowser) {
                GuiResearchBrowser gui = (GuiResearchBrowser)e.gui;
                int x1 = gui.field_146294_l / 2 - ConfigurationHandler.INSTANCE.getBrowserWidth() / 2 + 16 + 5;
                int x2 = gui.field_146294_l / 2 + ConfigurationHandler.INSTANCE.getBrowserWidth() / 2 - 16 - 5 - 1 - 24;
                int y = gui.field_146295_m / 2 + ConfigurationHandler.INSTANCE.getBrowserHeight() / 2 - 8 - 4;
                e.buttonList.add(new ButtonPrevPage(0, x1, y));
                e.buttonList.add(new ButtonNextPage(1, x2, y));
                ReflectionHelper.setPrivateValue(GuiResearchBrowser.class, (Object)gui, (Object)ConfigurationHandler.INSTANCE.getBrowserWidth(), (String[])new String[]{"paneWidth"});
                ReflectionHelper.setPrivateValue(GuiResearchBrowser.class, (Object)gui, (Object)ConfigurationHandler.INSTANCE.getBrowserHeight(), (String[])new String[]{"paneHeight"});
                currentPageTabs = null;
                BrowserPaging.updateMaxPageIndex(gui);
            }
        }

        @SubscribeEvent
        public void onGuiPreDraw(GuiScreenEvent.DrawScreenEvent.Pre e) {
            if (e.gui instanceof GuiResearchBrowser && this.ticks % 10 == 0 && !this.updated) {
                this.updated = true;
                BrowserPaging.updateMaxPageIndex((GuiResearchBrowser)e.gui);
            }
        }
    }

    private static class ButtonNextPage
    extends GuiButton {
        public ButtonNextPage(int id, int x, int y) {
            super(id, x, y, 25, 8, "");
            this.field_73735_i = -50.0f;
        }

        private void updateState() {
            this.field_146125_m = currentPageIndex < maxPageIndex;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            this.updateState();
            if (this.field_146125_m) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)2929);
                UtilsFX.bindTexture((String)"textures/gui/guiresearchtable2.png");
                ClientUtils.drawRectTextured(this.field_146128_h, this.field_146128_h + this.field_146120_f, this.field_146129_i, this.field_146129_i + this.field_146121_g, 207.0, 232.0, 208.0, 216.0, this.field_73735_i);
                GL11.glDisable((int)2929);
            }
        }

        public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
            this.updateState();
            if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                BrowserPaging.nextPage();
                return true;
            }
            return false;
        }
    }

    private static class ButtonPrevPage
    extends GuiButton {
        public ButtonPrevPage(int id, int x, int y) {
            super(id, x, y, 24, 8, "");
            this.field_73735_i = -50.0f;
        }

        private void updateState() {
            this.field_146125_m = currentPageIndex > 0;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            this.updateState();
            if (this.field_146125_m) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)2929);
                UtilsFX.bindTexture((String)"textures/gui/guiresearchtable2.png");
                ClientUtils.drawRectTextured(this.field_146128_h, this.field_146128_h + this.field_146120_f, this.field_146129_i, this.field_146129_i + this.field_146121_g, 184.0, 208.0, 208.0, 216.0, this.field_73735_i);
                GL11.glDisable((int)2929);
            }
        }

        public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
            this.updateState();
            if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                BrowserPaging.prevPage();
                return true;
            }
            return false;
        }
    }
}

