/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions;

import codechicken.nei.event.NEIConfigsLoadedEvent;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import ru.timeconqueror.tcneiadditions.TCNEIAdditions;

public class HandlerRemover {
    private static final ArrayList<Class<? extends ICraftingHandler>> recipeHandlersForRemoving = new ArrayList();
    private static final ArrayList<Class<? extends IUsageHandler>> usageHandlersForRemoving = new ArrayList();

    public static void delayRecipeHandlerRemoving(Class<? extends ICraftingHandler> handlerClass) {
        recipeHandlersForRemoving.add(handlerClass);
    }

    public static void delayUsageHandlerRemoving(Class<? extends IUsageHandler> handlerClass) {
        usageHandlersForRemoving.add(handlerClass);
    }

    @SubscribeEvent
    public void initiateRemoving(NEIConfigsLoadedEvent event) {
        TCNEIAdditions.LOGGER.info("Initiated handler removing...");
        Iterator craftingIterator = GuiCraftingRecipe.craftinghandlers.iterator();
        while (craftingIterator.hasNext()) {
            ICraftingHandler next = (ICraftingHandler)craftingIterator.next();
            for (Class<? extends ICraftingHandler> craftingHandlerClass : recipeHandlersForRemoving) {
                if (next.getClass() != craftingHandlerClass) continue;
                craftingIterator.remove();
                TCNEIAdditions.LOGGER.info("Crafting Recipes: found and removed standard " + craftingHandlerClass.getSimpleName() + " from Thaumcraft NEI Plugin");
            }
        }
        Iterator usageIterator = GuiUsageRecipe.usagehandlers.iterator();
        while (usageIterator.hasNext()) {
            IUsageHandler next = (IUsageHandler)usageIterator.next();
            for (Class<? extends IUsageHandler> usageHandlerClass : usageHandlersForRemoving) {
                if (next.getClass() != usageHandlerClass) continue;
                usageIterator.remove();
                TCNEIAdditions.LOGGER.info("Usage Recipes: found and removed standard " + usageHandlerClass.getSimpleName() + " from Thaumcraft NEI Plugin");
            }
        }
    }
}

