/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;
import ru.timeconqueror.tcneiadditions.client.ThaumcraftHooks;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.gui.GuiResearchRecipe;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class AspectFromItemStackHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tcneiadditions", "textures/gui/itemstack_background.png");
    private static final ResourceLocation THAUM_OVERLAYS = new ResourceLocation("Thaumcraft".toLowerCase(), "textures/gui/gui_researchbook_overlay.png");
    private static final int STACKS_OVERLAY_WIDTH = 163;
    private static final int STACKS_OVERLAY_HEIGHT = 74;
    private static final int STACKS_OVERLAY_START_X = TCNAClient.NEI_GUI_WIDTH / 2 - 81;
    private static final int STACKS_OVERLAY_START_Y = 57;
    private String playerName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private int ticks;

    public String getRecipeName() {
        return I18n.func_135052_a((String)"tcneiadditions.aspect_from_itemstack.title", (Object[])new Object[0]);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(ItemStack ingredient) {
        List<ItemStack> containingItemStacks;
        Aspect aspect;
        if (ingredient.func_77973_b() instanceof ItemAspect && Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(this.playerName, aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0]) && !(containingItemStacks = this.findContainingItemStacks(aspect)).isEmpty()) {
            new AspectCachedRecipe(aspect, containingItemStacks);
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)THAUM_OVERLAYS);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int textureSize = 16;
        float scaleFactor = 1.75f;
        int x = TCNAClient.NEI_GUI_WIDTH / 2;
        int y = 28;
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)1.0f);
        GL11.glTranslatef((float)-0.07f, (float)0.1f, (float)0.0f);
        GuiDraw.drawTexturedModalRect((int)(-textureSize / 2), (int)(-textureSize / 2), (int)20, (int)3, (int)16, (int)16);
        GL11.glTranslatef((float)0.07f, (float)-0.1f, (float)0.0f);
        GL11.glScalef((float)(1.0f / scaleFactor), (float)(1.0f / scaleFactor), (float)1.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
        GL11.glDisable((int)3042);
        if (!ThaumcraftHooks.isDataLoaded()) {
            GuiDraw.drawString((String)I18n.func_135052_a((String)"tcneiadditions.aspect_from_itemstack.still_load", (Object[])new Object[]{ThaumcraftHooks.getItemsLoaded(), ThaumcraftHooks.getTotalToLoad()}), (int)2, (int)47, (int)Color.GREEN.getRGB(), (boolean)true);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)BACKGROUND);
        GuiDraw.drawTexturedModalRect((int)STACKS_OVERLAY_START_X, (int)57, (int)0, (int)0, (int)163, (int)74);
    }

    public void drawForeground(int recipe) {
    }

    public String getGuiTexture() {
        return null;
    }

    public void onUpdate() {
        if (!ThaumcraftHooks.isDataLoaded()) {
            if (this.ticks < -1) {
                this.ticks = -1;
            }
            if (this.ticks % 200 == 0 && !this.arecipes.isEmpty() && this.arecipes.get(0) instanceof AspectCachedRecipe) {
                AspectCachedRecipe first = (AspectCachedRecipe)((Object)this.arecipes.get(0));
                List<ItemStack> fullList = this.findContainingItemStacks(first.aspect);
                first.initStackList(fullList);
            }
            ++this.ticks;
        }
    }

    private List<ItemStack> findContainingItemStacks(Aspect aspect) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        List list = (List)Thaumcraft.proxy.getScannedObjects().get(this.playerName);
        if (list != null) {
            for (String itemStackCache : list) {
                try {
                    itemStackCache = itemStackCache.substring(1);
                    ItemStack is = GuiResearchRecipe.getFromCache((int)Integer.parseInt(itemStackCache));
                    if (is == null) continue;
                    AspectList tags = ThaumcraftCraftingManager.getObjectTags((ItemStack)is);
                    if ((tags = ThaumcraftCraftingManager.getBonusTags((ItemStack)is, (AspectList)tags)).size() <= 0) continue;
                    ItemStack is2 = is.func_77946_l();
                    is2.field_77994_a = tags.getAmount(aspect);
                    if (is2.field_77994_a <= 0) continue;
                    stacks.add(is2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        stacks.sort(Comparator.comparingInt(itemStack -> itemStack.field_77994_a).reversed());
        return stacks;
    }

    private class AspectCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private static final int STACKS_COUNT = 36;
        private Aspect aspect;
        private int start;
        private ItemStack[] localPageStacks;
        private List<PositionedStack> ingredients;
        private PositionedStack result;
        private AspectCachedRecipe next;

        public AspectCachedRecipe(Aspect aspect, List<ItemStack> fullItemStackList) {
            this(aspect, fullItemStackList, 0);
        }

        private AspectCachedRecipe(Aspect aspect, List<ItemStack> fullItemStackList, int start) {
            super((TemplateRecipeHandler)AspectFromItemStackHandler.this);
            this.ingredients = null;
            this.next = null;
            this.start = start;
            this.aspect = aspect;
            ItemStack aspectStack = new ItemStack(ModItems.itemAspect);
            ItemAspect.setAspect((ItemStack)aspectStack, (Aspect)aspect);
            this.result = new PositionedStack((Object)aspectStack, TCNAClient.NEI_GUI_WIDTH / 2 - 8, 20);
            AspectFromItemStackHandler.this.arecipes.add(this);
            this.initStackList(fullItemStackList);
        }

        private void initStackList(List<ItemStack> fullItemStackList) {
            this.localPageStacks = this.getItemsInInterval(fullItemStackList);
            this.ingredients = null;
            if (this.next != null) {
                this.next.initStackList(fullItemStackList);
            } else if (this.start + 36 < fullItemStackList.size()) {
                this.next = new AspectCachedRecipe(this.aspect, fullItemStackList, this.start + 36);
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            if (this.ingredients == null) {
                this.ingredients = new ArrayList<PositionedStack>(this.localPageStacks.length);
                for (int i = 0; i < this.localPageStacks.length; ++i) {
                    int x = STACKS_OVERLAY_START_X + 1 + i % 9 * 18;
                    int y = 58 + i / 9 * 18;
                    ItemStack stack = this.localPageStacks[i];
                    this.ingredients.add(new PositionedStack((Object)stack, x, y));
                }
            }
            return this.ingredients;
        }

        private ItemStack[] getItemsInInterval(List<ItemStack> stacksIn) {
            int count = this.start + 36 <= stacksIn.size() ? 36 : stacksIn.size() - this.start;
            ItemStack[] itemStacks = new ItemStack[count];
            for (int i = 0; i < itemStacks.length; ++i) {
                itemStacks[i] = stacksIn.get(this.start + i);
            }
            return itemStacks;
        }
    }
}

