/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.CrucibleRecipeHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.client.lib.UtilsFX;

public class TCNACrucibleRecipeHandler
extends CrucibleRecipeHandler {
    private final String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                CrucibleRecipe tcRecipe;
                CrucibleCachedRecipe recipe;
                if (!(o instanceof CrucibleRecipe) || !(recipe = new CrucibleCachedRecipe(tcRecipe = (CrucibleRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.key))).isValid()) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(recipe.aspects);
            }
        } else if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CrucibleRecipe tcRecipe : TCUtil.getCrucibleRecipes(result)) {
            boolean shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.key);
            CrucibleCachedRecipe recipe = new CrucibleCachedRecipe(tcRecipe, shouldShowRecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<CrucibleRecipe> tcRecipeList = TCUtil.getCrucibleRecipesByInput(ingredient);
        for (CrucibleRecipe tcRecipe : tcRecipeList) {
            if (tcRecipe == null || !TCUtil.shouldShowRecipe(this.userName, tcRecipe.key)) continue;
            CrucibleCachedRecipe recipe = new CrucibleCachedRecipe(tcRecipe, true);
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public void drawBackground(int recipeIndex) {
        CrucibleCachedRecipe recipe = (CrucibleCachedRecipe)((Object)this.arecipes.get(recipeIndex));
        if (recipe.shouldShowRecipe) {
            super.drawBackground(recipeIndex);
            return;
        }
        int x = 30;
        int y = 3;
        GL11.glPushMatrix();
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.75f, (float)1.75f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)3, (int)56, (int)17);
        GL11.glPopMatrix();
    }

    public void drawExtras(int recipeIndex) {
        CrucibleCachedRecipe recipe = (CrucibleCachedRecipe)((Object)this.arecipes.get(recipeIndex));
        if (recipe.shouldShowRecipe) {
            super.drawExtras(recipeIndex);
        } else {
            String textToDraw = I18n.func_135052_a((String)"tcneiadditions.research.missing", (Object[])new Object[0]);
            int y = 28;
            for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)Color.BLACK.getRGB(), (boolean)false);
                y += 11;
            }
        }
        if (TCNAConfig.showResearchKey) {
            int y = 135;
            String textToDraw = I18n.func_135052_a((String)"tcneiadditions.research.researchKey", (Object[])new Object[]{recipe.researchKey});
            for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)Color.BLACK.getRGB(), (boolean)false);
                y += 11;
            }
        }
    }

    private class CrucibleCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<PositionedStack> ingredients;
        public PositionedStack result;
        private AspectList aspects;
        private final boolean shouldShowRecipe;
        private final String researchKey;

        public CrucibleCachedRecipe(CrucibleRecipe recipe, boolean shouldShowRecipe) {
            super((TemplateRecipeHandler)TCNACrucibleRecipeHandler.this);
            this.setIngredient(recipe.catalyst);
            this.setResult(recipe.getRecipeOutput());
            this.setAspectList(recipe.aspects);
            this.shouldShowRecipe = shouldShowRecipe;
            this.researchKey = recipe.key != null ? recipe.key : EnumChatFormatting.ITALIC + "null";
            NEIHelper.addAspectsToIngredients((AspectList)this.aspects, this.ingredients, (int)2);
        }

        protected void setIngredient(Object in) {
            if (in != null && NEIServerUtils.extractRecipeItems((Object)in).length > 0) {
                PositionedStack stack = new PositionedStack(in, 51, 30, false);
                stack.setMaxSize(1);
                this.ingredients = new ArrayList<PositionedStack>(Collections.singletonList(stack));
            }
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        protected void setResult(ItemStack out) {
            if (out != null) {
                this.result = new PositionedStack((Object)out, 71, 8, false);
            }
        }

        protected void setAspectList(AspectList aspects) {
            this.aspects = aspects;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return this.getCycledIngredients(TCNACrucibleRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }
    }
}

