/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.util;

import codechicken.nei.NEIServerUtils;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;

public class TCUtil {
    public static List<InfusionRecipe> getInfusionRecipes(ItemStack result) {
        ArrayList<InfusionRecipe> list = new ArrayList<InfusionRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            ItemStack output;
            if (!(r instanceof InfusionRecipe) || !(((InfusionRecipe)r).getRecipeOutput() instanceof ItemStack) || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)(output = (ItemStack)((InfusionRecipe)r).getRecipeOutput()), (ItemStack)result)) continue;
            list.add((InfusionRecipe)r);
        }
        return list;
    }

    public static List<CrucibleRecipe> getCrucibleRecipes(ItemStack result) {
        ArrayList<CrucibleRecipe> list = new ArrayList<CrucibleRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            ItemStack output;
            if (!(r instanceof CrucibleRecipe) || ((CrucibleRecipe)r).getRecipeOutput() == null || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)(output = ((CrucibleRecipe)r).getRecipeOutput()), (ItemStack)result)) continue;
            list.add((CrucibleRecipe)r);
        }
        return list;
    }

    public static List<InfusionRecipe> getInfusionRecipesByInput(ItemStack input) {
        ArrayList<InfusionRecipe> list = new ArrayList<InfusionRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            InfusionRecipe tcRecipe;
            if (!(r instanceof InfusionRecipe) || (tcRecipe = (InfusionRecipe)r).getRecipeInput() == null || TCUtil.getAssociatedItemStack(tcRecipe.getRecipeOutput()) == null) continue;
            if (input.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)input).getAspects()[0];
                if (!tcRecipe.getAspects().aspects.containsKey(aspect)) continue;
                list.add(tcRecipe);
                continue;
            }
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)tcRecipe.getRecipeInput(), (ItemStack)input) && !TCUtil.matchInfusionComponents(tcRecipe.getComponents(), input)) continue;
            list.add(tcRecipe);
        }
        return list;
    }

    public static List<CrucibleRecipe> getCrucibleRecipesByInput(ItemStack input) {
        ArrayList<CrucibleRecipe> list = new ArrayList<CrucibleRecipe>();
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            if (r == null || !(r instanceof CrucibleRecipe)) continue;
            CrucibleRecipe tcRecipe = (CrucibleRecipe)r;
            if (input.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)input).getAspects()[0];
                if (!tcRecipe.aspects.aspects.containsKey(aspect)) continue;
                list.add(tcRecipe);
                continue;
            }
            if (!tcRecipe.catalystMatches(input)) continue;
            list.add(tcRecipe);
        }
        return list;
    }

    public static boolean matchInfusionComponents(ItemStack[] components, ItemStack stack) {
        for (ItemStack component : components) {
            for (ItemStack toCompare : TCUtil.getOreDictionaryMatchingItemsForInfusion(component)) {
                if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)toCompare, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldShowRecipe(String username, String researchKey) {
        return ThaumcraftApiHelper.isResearchComplete((String)username, (String)researchKey) || TCNAConfig.showLockedRecipes;
    }

    public static ItemStack getAssociatedItemStack(Object o) {
        ItemStack stack;
        if (o instanceof ItemStack && (stack = (ItemStack)o).func_77973_b() == null) {
            return stack;
        }
        return NEIHelper.getAssociatedItemStack((Object)o);
    }

    public static List<ItemStack> getOreDictionaryMatchingItemsForInfusion(ItemStack stack) {
        int oreID = OreDictionary.getOreID((ItemStack)stack);
        if (oreID != -1 && !OreDictionary.getOreName((int)oreID).equals("dye")) {
            return OreDictionary.getOres((Integer)oreID);
        }
        return Collections.singletonList(stack);
    }
}

