/*
 * Decompiled with CFR 0.152.
 */
package thaumicboots.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IRunicArmor;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.armor.Hover;
import thaumicboots.api.IBoots;
import thaumicboots.api.ITBootJumpable;
import thaumicboots.api.ITBootSpeed;

public class ItemBoots
extends ItemArmor
implements ITBootJumpable,
ITBootSpeed,
IVisDiscountGear,
IRunicArmor,
IRepairable,
IBoots {
    public IIcon icon;
    public float runBonus;
    public float longrunningbonus;
    public int visDiscount;
    public int runicCharge;
    public int tier;
    public boolean steadyBonus;
    public boolean negateFall;
    public boolean waterEffects;
    public String iconResPath;
    public String armorResPath;
    public String unlocalisedName;
    public double jumpBonus;
    public boolean omniMovement;

    public ItemBoots(ItemArmor.ArmorMaterial par2EnumArmorMaterial, int par3, int par4) {
        super(par2EnumArmorMaterial, par3, par4);
        this.setBootsData();
    }

    protected void setBootsData() {
        this.runicCharge = 0;
        this.visDiscount = 0;
        this.runBonus = 0.165f;
        this.jumpBonus = 0.0;
        this.omniMovement = false;
        this.tier = 0;
        this.steadyBonus = false;
        this.negateFall = true;
        this.waterEffects = false;
        this.longrunningbonus = 0.0f;
        this.iconResPath = "thaumicboots:electricVoid_16x";
        this.armorResPath = "thaumicboots:model/electricbootsVoidwalker.png";
        this.unlocalisedName = "ItemElectricVoid";
    }

    @Override
    public double getJumpModifier() {
        return this.jumpBonus;
    }

    @Override
    public float getSpeedModifier() {
        return this.runBonus;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a(this.iconResPath);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (this.visDiscount > 0) {
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"tc.visdiscount") + ": " + this.visDiscount + "%");
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.armorResPath;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public int getRunicCharge(ItemStack arg0) {
        return this.runicCharge;
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        return this.visDiscount;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77969_a(new ItemStack(Items.field_151116_aA)) || super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    protected float computeBonus(ItemStack itemStack, EntityPlayer player) {
        int ticks = player.field_71071_by.func_70440_f((int)0).field_77990_d.func_74762_e("runTicks");
        return this.runBonus + (float)ticks * 0.2f * this.longrunningbonus;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.negateFall && player.field_70143_R > 0.0f) {
            player.field_70143_R = 0.0f;
        }
        boolean omniMode = this.isOmniEnabled(itemStack);
        if (player.field_70701_bs == 0.0f && player.field_70702_br == 0.0f && omniMode || player.field_70701_bs <= 0.0f && !omniMode) {
            return;
        }
        float bonus = this.getSpeedModifier();
        this.stepHeight(player);
        if (this.steadyBonus) {
            this.runningTicks(player);
            bonus = this.computeBonus(itemStack, player);
        }
        this.applyFinalBonus(bonus, player, itemStack);
    }

    public void applyFinalBonus(float bonus, EntityPlayer player, ItemStack itemStack) {
        bonus = (float)((double)bonus * this.isSpeedEnabled(itemStack));
        this.applyBonus(player, bonus, itemStack);
    }

    public void stepHeight(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (!Thaumcraft.instance.entityEventHandler.prevStep.containsKey(player.func_145782_y())) {
            Thaumcraft.instance.entityEventHandler.prevStep.put(player.func_145782_y(), Float.valueOf(player.field_70138_W));
        }
        player.field_70138_W = 1.0f;
    }

    public void runningTicks(EntityPlayer player) {
        if (!player.field_71071_by.func_70440_f(0).func_77942_o()) {
            NBTTagCompound par1NBTTagCompound = new NBTTagCompound();
            player.field_71071_by.func_70440_f(0).func_77982_d(par1NBTTagCompound);
            player.field_71071_by.func_70440_f((int)0).field_77990_d.func_74768_a("runTicks", 0);
        }
    }

    public void applyBonus(EntityPlayer player, float bonus, ItemStack itemStack) {
        if (this.waterEffects && player.func_70090_H()) {
            bonus *= 0.25f;
        }
        if (player.field_70122_E || player.func_70617_f_() || player.field_71075_bZ.field_75100_b) {
            if ((double)player.field_70702_br != 0.0 && itemStack.field_77990_d.func_74767_n("omni")) {
                player.func_70060_a(player.field_70702_br, 0.0f, bonus);
            } else if ((double)player.field_70701_bs != 0.0) {
                player.func_70060_a(0.0f, player.field_70701_bs, bonus);
            }
        } else {
            player.field_70747_aH = Hover.getHover((int)player.func_145782_y()) ? 0.03f : 0.05f;
        }
    }
}

