/*
 * Decompiled with CFR 0.152.
 */
package thaumicboots.main;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import thaumcraft.api.ThaumcraftApi;
import thaumicboots.item.boots.unique.ItemChristmasBoots;
import thaumicboots.item.boots.unique.ItemSeasonBoots;
import thaumicboots.item.boots.unique.ItemSlowBoots;
import thaumicboots.item.tools.ItemThaumicInterfacer;

public class Config {
    public static final String CATEGORY_MODULES = "modules";
    public static final String BOOTS = "boots";
    public static boolean thaumcraftActive;
    public static Item arcaniumLens;
    public static Item seasonBoots;
    public static Item christmasBoots;
    public static Item slowBoots;
    public static Configuration configuration;
    private static Config instance;
    public static boolean gtnhLibActive;
    public static boolean taintedMagicActive;
    public static boolean emtActive;
    public static boolean explorationsActive;
    public static double bootsJumpChangeRate;
    public static double bootsSpeedChangeRate;
    public static boolean allowInertiaCancelingFeature;

    public static void Init(File configFile) {
        if (instance != null) {
            return;
        }
        instance = new Config();
        FMLCommonHandler.instance().bus().register((Object)instance);
        configuration = new Configuration(configFile);
        configuration.load();
        Config.processConfigFile();
        configuration.save();
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("Thaumic Boots") && configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void saveConfigs() {
        configuration.save();
    }

    public static void setupBlocks() {
    }

    public static void setupItems() {
        arcaniumLens = new ItemThaumicInterfacer();
        GameRegistry.registerItem((Item)arcaniumLens, (String)arcaniumLens.func_77658_a());
        seasonBoots = new ItemSeasonBoots(ThaumcraftApi.armorMatSpecial, 4, 3);
        GameRegistry.registerItem((Item)seasonBoots, (String)seasonBoots.func_77658_a());
        christmasBoots = new ItemChristmasBoots(ThaumcraftApi.armorMatSpecial, 4, 3);
        GameRegistry.registerItem((Item)christmasBoots, (String)christmasBoots.func_77658_a());
        slowBoots = new ItemSlowBoots(ThaumcraftApi.armorMatSpecial, 4, 3);
        GameRegistry.registerItem((Item)slowBoots, (String)slowBoots.func_77658_a());
    }

    private static void processConfigFile() {
        Config.syncConfigs();
    }

    private static void syncConfigs() {
        Config.doModuleConfigs();
    }

    private static void doModuleConfigs() {
        thaumcraftActive = configuration.get(CATEGORY_MODULES, "Thaumcraft", true).getBoolean();
        Property p = configuration.get(CATEGORY_MODULES, "Electro-Magic-Tools", true);
        gtnhLibActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "Tainted-Magic", true);
        taintedMagicActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "Electro-Magic-Tools", true);
        emtActive = p.getBoolean();
        p = configuration.get(CATEGORY_MODULES, "Thaumic_Exploration", true);
        explorationsActive = p.getBoolean();
        p = configuration.get(BOOTS, "Jump-Change-Rate", 0.25, "The rate that boot jump modifier changes when the Jump Modulation key is pressed. 'I will not provide support to those who change this -Alastor'", 0.01, 1.0);
        bootsJumpChangeRate = p.getDouble();
        p = configuration.get(BOOTS, "Speed-Change-Rate", 0.25, "The rate that boot speed modifier changes when the Speed Modulation key is pressed. 'I will not provide support to those who change this -Alastor'", 0.01, 1.0);
        bootsSpeedChangeRate = p.getDouble();
        p = configuration.get(BOOTS, "Allow-Inertia-Canceling-Feature", true);
        allowInertiaCancelingFeature = p.getBoolean();
    }

    static {
        instance = null;
    }
}

