/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.container.ContainerWithNetworkTool;
import thaumicenergistics.common.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaStorageBus;
import thaumicenergistics.common.parts.PartEssentiaStorageBus;

public class ContainerPartEssentiaStorageBus
extends ContainerWithNetworkTool {
    private static final int UPGRADE_SLOT_X = 187;
    private static final int UPGRADE_SLOT_Y = 8;
    private static int PLAYER_INV_POSITION_Y = 102;
    private static int HOTBAR_INV_POSITION_Y = 160;
    private final PartEssentiaStorageBus storageBus;
    private final ArrayList<Aspect> filteredAspects = new ArrayList(9);
    private boolean isVoidAllowed = false;

    public ContainerPartEssentiaStorageBus(PartEssentiaStorageBus part, EntityPlayer player) {
        super(player);
        this.storageBus = part;
        for (int i = 0; i < 9; ++i) {
            this.filteredAspects.add(null);
        }
        this.addUpgradeSlots(part.getUpgradeInventory(), 1, 187, 8);
        this.bindPlayerInventory((IInventory)player.field_71071_by, PLAYER_INV_POSITION_Y, HOTBAR_INV_POSITION_Y);
        this.bindToNetworkTool(player.field_71071_by, part.getHost().getLocation(), 0, 0);
    }

    @Override
    protected boolean detectAndSendChangesMP(EntityPlayerMP playerMP) {
        boolean updateFilters = false;
        for (int filterIndex = 0; filterIndex < 9; ++filterIndex) {
            if (this.filteredAspects.get(filterIndex) == this.storageBus.getFilteredAspect(filterIndex)) continue;
            this.filteredAspects.set(filterIndex, this.storageBus.getFilteredAspect(filterIndex));
            updateFilters = true;
        }
        if (updateFilters) {
            Packet_C_AspectSlot.setFilterList(this.filteredAspects, this.player);
        }
        if (this.isVoidAllowed != this.storageBus.isVoidAllowed()) {
            this.isVoidAllowed = this.storageBus.isVoidAllowed();
            Packet_C_EssentiaStorageBus.sendIsVoidAllowed(this.player, this.isVoidAllowed);
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.storageBus != null) {
            return this.storageBus.isPartUseableByPlayer(player);
        }
        return false;
    }

    public void setFilteredAspects(List<Aspect> filteredAspects) {
        Packet_C_AspectSlot.setFilterList(filteredAspects, this.player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            if (this.storageBus != null && this.storageBus.addFilteredAspectFromItemstack(player, slot.func_75211_c())) {
                return null;
            }
            return super.func_82846_b(player, slotNumber);
        }
        return null;
    }
}

