/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.grid;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.api.grid.IMEEssentiaMonitorReceiver;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.api.storage.IEssentiaRepo;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.common.storage.AspectStack;
import thaumicenergistics.common.storage.EssentiaRepo;

public class EssentiaMonitor
implements IMEEssentiaMonitor,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    public static final double AE_PER_ESSENTIA = 0.3;
    protected final HashMap<IMEEssentiaMonitorReceiver, Object> listeners;
    protected IMEMonitor<IAEFluidStack> fluidMonitor;
    protected IEnergyGrid energyGrid;
    private Collection<IAspectStack> cacheView;
    private WeakReference<Object> token;
    private final IEssentiaRepo cache = new EssentiaRepo();
    protected boolean cacheNeedsUpdate = false;

    public EssentiaMonitor() {
        this.listeners = new HashMap();
    }

    public EssentiaMonitor(IMEMonitor<IAEFluidStack> fluidMonitor, IEnergyGrid energyGrid, Object validationToken) {
        this();
        this.wrap(fluidMonitor, energyGrid, validationToken);
    }

    private long injectEssentiaSafely(Aspect aspect, long amount, Actionable mode, BaseActionSource source, GaseousEssentia essentiaGas) {
        IAEFluidStack fluidRequest = EssentiaConversionHelper.INSTANCE.createAEFluidStackInEssentiaUnits(essentiaGas, amount);
        IAEFluidStack fluidRejected = (IAEFluidStack)this.fluidMonitor.injectItems((IAEStack)fluidRequest, mode, source);
        if (fluidRejected != null && fluidRejected.getStackSize() > 0L) {
            if (fluidRejected.getStackSize() == fluidRequest.getStackSize()) {
                return amount;
            }
            long rejectedAdjustedAmount = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(fluidRejected.getStackSize());
            return rejectedAdjustedAmount;
        }
        return 0L;
    }

    private void notifyListeners(List<IAspectStack> changes) {
        ImmutableList changeList = ImmutableList.copyOf(changes);
        Iterator<Map.Entry<IMEEssentiaMonitorReceiver, Object>> entryIterator = this.listeners.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<IMEEssentiaMonitorReceiver, Object> entry = entryIterator.next();
            if (entry.getKey().isValid(entry.getValue())) {
                entry.getKey().postChange(this, (Iterable<IAspectStack>)changeList);
                continue;
            }
            entryIterator.remove();
        }
    }

    private boolean setAspectCraftability(Aspect aspect, boolean isCraftable, boolean doNotify) {
        IAspectStack stack = this.cache.getOrDefault(aspect, null);
        boolean changesMade = false;
        if (stack == null) {
            if (isCraftable) {
                this.cache.postChange(aspect, 0L, true);
                changesMade = true;
            }
        } else if (stack.isEmpty() && !isCraftable) {
            this.cache.remove(aspect);
            changesMade = true;
        } else if (stack.getCraftable() != isCraftable) {
            stack.setCraftable(isCraftable);
            changesMade = true;
        }
        if (doNotify && changesMade && this.listeners.size() > 0) {
            ArrayList<IAspectStack> changes = new ArrayList<IAspectStack>();
            changes.add(new AspectStack(aspect, 0L, isCraftable));
            this.notifyListeners(changes);
        }
        return changesMade;
    }

    protected void setAspectCraftability(Aspect aspect, boolean isCraftable) {
        this.setAspectCraftability(aspect, isCraftable, true);
    }

    protected void setCraftableAspects(HashSet<Aspect> aspects) {
        ArrayList<IAspectStack> changes = new ArrayList<IAspectStack>();
        for (Aspect aspect : aspects) {
            if (!this.setAspectCraftability(aspect, true, false)) continue;
            changes.add(new AspectStack(aspect, 0L, true));
        }
        if (changes.size() > 0 && this.listeners.size() > 0) {
            this.notifyListeners(changes);
        }
    }

    protected void updateCacheToMatchNetwork() {
        boolean hasListeners;
        ArrayList<IAspectStack> aspectChanges = null;
        HashSet<Aspect> previousAspects = null;
        boolean bl = hasListeners = this.listeners.size() > 0;
        if (hasListeners) {
            aspectChanges = new ArrayList<IAspectStack>();
            previousAspects = new HashSet<Aspect>();
            previousAspects.addAll(this.cache.aspectSet());
        } else {
            this.cache.clear();
        }
        if (this.energyGrid.isNetworkPowered()) {
            IItemList fluidStackList = this.fluidMonitor.getStorageList();
            for (IAEFluidStack fluidStack : fluidStackList) {
                if (!(fluidStack.getFluid() instanceof GaseousEssentia)) continue;
                Aspect aspect = ((GaseousEssentia)fluidStack.getFluid()).getAspect();
                Long newAmount = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize());
                IAspectStack prevStack = this.cache.setAspect(aspect, newAmount, false);
                if (!hasListeners) continue;
                previousAspects.remove(aspect);
                long diff = newAmount - (prevStack != null ? prevStack.getStackSize() : 0L);
                if (diff == 0L) continue;
                aspectChanges.add(new AspectStack(aspect, diff));
            }
        }
        if (hasListeners) {
            for (Aspect aspect : previousAspects) {
                aspectChanges.add(new AspectStack(aspect, -this.cache.remove(aspect).getStackSize(), false));
            }
            this.notifyListeners(aspectChanges);
        }
        this.cacheNeedsUpdate = false;
    }

    @Override
    public void addListener(IMEEssentiaMonitorReceiver listener, Object verificationToken) {
        if (verificationToken == null) {
            throw new NullPointerException("Verification token can not be null");
        }
        if (this.listeners.size() == 0 && this.cacheNeedsUpdate) {
            this.updateCacheToMatchNetwork();
        }
        this.listeners.put(listener, verificationToken);
    }

    public void detach() {
        if (this.fluidMonitor != null) {
            this.fluidMonitor.removeListener((IMEMonitorHandlerReceiver)this);
            this.token = null;
        }
    }

    @Override
    public long extractEssentia(Aspect aspect, long amount, Actionable mode, BaseActionSource source, boolean powered) {
        double powerRequest;
        double powerReceived;
        if (aspect == null || amount <= 0L) {
            return 0L;
        }
        GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspect);
        if (essentiaGas == null) {
            return 0L;
        }
        if (powered && (powerReceived = this.energyGrid.extractAEPower(powerRequest = 0.3 * (double)amount, Actionable.SIMULATE, PowerMultiplier.CONFIG)) < powerRequest) {
            return 0L;
        }
        IAEFluidStack fluidRequest = EssentiaConversionHelper.INSTANCE.createAEFluidStackInEssentiaUnits(essentiaGas, amount);
        IAEFluidStack fluidReceived = (IAEFluidStack)this.fluidMonitor.extractItems((IAEStack)fluidRequest, mode, source);
        if (fluidReceived == null || fluidReceived.getStackSize() <= 0L) {
            return 0L;
        }
        long extractedAmount = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(fluidReceived.getStackSize());
        if (powered && mode == Actionable.MODULATE) {
            this.energyGrid.extractAEPower(0.3 * (double)extractedAmount, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return extractedAmount;
    }

    @Override
    public long getEssentiaAmount(Aspect aspect) {
        if (!this.energyGrid.isNetworkPowered()) {
            return 0L;
        }
        if (this.cacheNeedsUpdate) {
            this.updateCacheToMatchNetwork();
        }
        if (this.cache.containsAspect(aspect)) {
            return this.cache.get(aspect).getStackSize();
        }
        return 0L;
    }

    @Override
    public Collection<IAspectStack> getEssentiaList() {
        if (!this.energyGrid.isNetworkPowered()) {
            return new ArrayList<IAspectStack>();
        }
        if (this.cacheNeedsUpdate) {
            this.updateCacheToMatchNetwork();
        }
        if (this.cacheView == null) {
            this.cacheView = Collections.unmodifiableCollection(this.cache.getAll());
        }
        return this.cacheView;
    }

    @Override
    public long injectEssentia(Aspect aspect, long amount, Actionable mode, BaseActionSource source, boolean powered) {
        double powerRequest;
        double powerReceived;
        long rejectedAmount;
        if (aspect == null || amount <= 0L) {
            return amount;
        }
        GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspect);
        if (essentiaGas == null) {
            return amount;
        }
        long injectedAmount = amount;
        if ((injectedAmount -= (rejectedAmount = this.injectEssentiaSafely(aspect, injectedAmount, Actionable.SIMULATE, source, essentiaGas))) == 0L) {
            return amount;
        }
        if (powered && (powerReceived = this.energyGrid.extractAEPower(powerRequest = 0.3 * (double)injectedAmount, Actionable.SIMULATE, PowerMultiplier.CONFIG)) < powerRequest) {
            return amount;
        }
        if (mode == Actionable.MODULATE) {
            rejectedAmount = this.injectEssentiaSafely(aspect, injectedAmount, Actionable.MODULATE, source, essentiaGas);
            injectedAmount -= rejectedAmount;
            if (powered) {
                powerRequest = 0.3 * (double)injectedAmount;
                this.energyGrid.extractAEPower(powerRequest, Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
        }
        return amount - injectedAmount;
    }

    public boolean isValid(Object verificationToken) {
        Object vToken;
        return this.token != null && this.token.equals(verificationToken) && (vToken = this.token.get()) != null;
    }

    public void onListUpdate() {
        this.cacheNeedsUpdate = true;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> fluidChanges, BaseActionSource actionSource) {
        if (this.cacheNeedsUpdate) {
            return;
        }
        if (fluidChanges == null) {
            return;
        }
        boolean hasListeners = this.listeners.size() > 0;
        ArrayList<IAspectStack> aspectChanges = null;
        for (IAEFluidStack change : fluidChanges) {
            IAspectStack changeStack;
            if (!(change.getFluid() instanceof GaseousEssentia)) continue;
            Aspect aspect = ((GaseousEssentia)change.getFluid()).getAspect();
            long changeAmount = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(change.getStackSize());
            IAspectStack previous = this.cache.postChange(aspect, changeAmount, null);
            if (!hasListeners) continue;
            if (aspectChanges == null) {
                aspectChanges = new ArrayList<IAspectStack>();
            }
            if (previous != null) {
                changeStack = previous;
                previous.setStackSize(changeAmount);
            } else {
                changeStack = new AspectStack(aspect, changeAmount);
            }
            aspectChanges.add(changeStack);
        }
        if (aspectChanges != null && aspectChanges.size() > 0) {
            this.notifyListeners((List<IAspectStack>)aspectChanges);
        }
    }

    @Override
    public void removeListener(IMEEssentiaMonitorReceiver listener) {
        this.listeners.remove(listener);
    }

    public void wrap(IMEMonitor<IAEFluidStack> fluidMonitor, IEnergyGrid energyGrid, Object validationToken) {
        if (validationToken == null) {
            throw new NullPointerException("Validation Token Can Not Be Null");
        }
        this.token = new WeakReference<Object>(validationToken);
        this.fluidMonitor = fluidMonitor;
        this.energyGrid = energyGrid;
        this.fluidMonitor.addListener((IMEMonitorHandlerReceiver)this, this.token);
        this.cacheNeedsUpdate = true;
    }
}

