/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.items;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.core.localization.GuiText;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.inventory.HandlerItemEssentiaCell;
import thaumicenergistics.common.inventory.HandlerItemEssentiaCellCreative;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.storage.AspectStack;
import thaumicenergistics.common.storage.AspectStackComparator;
import thaumicenergistics.common.storage.EnumEssentiaStorageTypes;

public class ItemEssentiaCell
extends Item
implements ICellHandler {
    private static final int CELL_STATUS_MISSING = 0;
    private static final int CELL_STATUS_HAS_ROOM = 1;
    private static final int CELL_STATUS_TYPES_FULL = 2;
    private static final int CELL_STATUS_FULL = 3;
    private IIcon[] icons;

    public ItemEssentiaCell() {
        AEApi.instance().registries().cell().addCellHandler((ICellHandler)this);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    private void addContentsToCellDescription(HandlerItemEssentiaCell cellHandler, List displayList, EntityPlayer player) {
        List<IAspectStack> cellAspects = cellHandler.getStoredEssentia();
        Collections.sort(cellAspects, new AspectStackComparator());
        for (IAspectStack currentStack : cellAspects) {
            if (currentStack == null) continue;
            String aspectChatColor = currentStack.getChatColor();
            String aspectInfo = String.format("  %s%s%s x %d", aspectChatColor, currentStack.getAspectName(player), EnumChatFormatting.WHITE, currentStack.getStackSize());
            displayList.add(aspectInfo);
        }
    }

    private List<String> addPartitionsToCellDescription(HandlerItemEssentiaCell cellHandler, EntityPlayer player) {
        return cellHandler.getPartitionAspects().stream().filter(Objects::nonNull).map(aspect -> new AspectStack((Aspect)aspect, 1L)).sorted(new AspectStackComparator()).map(aspect -> String.format("  %s%s", aspect.getChatColor(), aspect.getAspectName(player))).collect(Collectors.toList());
    }

    public void func_77624_a(ItemStack essentiaCell, EntityPlayer player, List displayList, boolean advancedItemTooltips) {
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(essentiaCell, null, StorageChannel.FLUIDS);
        if (!(handler instanceof HandlerItemEssentiaCell)) {
            return;
        }
        HandlerItemEssentiaCell cellHandler = (HandlerItemEssentiaCell)handler;
        String bytesTip = String.format(ThEStrings.Tooltip_CellBytes.getLocalized(), NumberFormat.getInstance().format(cellHandler.getUsedBytes()), NumberFormat.getInstance().format(cellHandler.getTotalBytes()));
        String typesTip = String.format(ThEStrings.Tooltip_CellTypes.getLocalized(), NumberFormat.getInstance().format(cellHandler.getUsedTypes()), NumberFormat.getInstance().format(cellHandler.getTotalTypes()));
        displayList.add(bytesTip);
        displayList.add(typesTip);
        if (cellHandler.isPartitioned()) {
            displayList.add(GuiText.Partitioned.getLocal());
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                displayList.add(GuiText.Filter.getLocal() + ": ");
                displayList.addAll(this.addPartitionsToCellDescription(cellHandler, player));
            }
        }
        if (cellHandler.getUsedTypes() > 0L) {
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                displayList.add(ThEStrings.Tooltip_CellContains.getLocalized() + ":");
                this.addContentsToCellDescription(cellHandler, displayList, player);
            } else {
                displayList.add(EnumChatFormatting.WHITE + EnumChatFormatting.ITALIC.toString() + ThEStrings.Tooltip_ItemStackDetails.getLocalized());
            }
        }
    }

    public double cellIdleDrain(ItemStack itemStack, IMEInventory handler) {
        return EnumEssentiaStorageTypes.fromIndex[itemStack.func_77960_j()].idleAEPowerDrain;
    }

    public IMEInventoryHandler<?> getCellInventory(ItemStack essentiaCell, ISaveProvider saveProvider, StorageChannel channel) {
        if (channel != StorageChannel.FLUIDS || !(essentiaCell.func_77973_b() instanceof ItemEssentiaCell)) {
            return null;
        }
        if (essentiaCell.func_77960_j() == EnumEssentiaStorageTypes.Type_Creative.index) {
            return new HandlerItemEssentiaCellCreative(essentiaCell, saveProvider);
        }
        return new HandlerItemEssentiaCell(essentiaCell, saveProvider);
    }

    public IIcon func_77617_a(int dmg) {
        int index = MathHelper.func_76125_a((int)dmg, (int)0, (int)(EnumEssentiaStorageTypes.fromIndex.length - 1));
        return this.icons[index];
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        int index = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(EnumEssentiaStorageTypes.fromIndex.length - 1));
        return EnumEssentiaStorageTypes.fromIndex[index].rarity;
    }

    public int getStatusForCell(ItemStack essentiaCell, IMEInventory handler) {
        if (handler == null) {
            return 0;
        }
        HandlerItemEssentiaCell cellHandler = (HandlerItemEssentiaCell)handler;
        if (cellHandler.isCreative()) {
            return 2;
        }
        if (cellHandler.getUsedBytes() == cellHandler.getTotalBytes()) {
            return 3;
        }
        if (cellHandler.getUsedTypes() == cellHandler.getTotalTypes()) {
            return 2;
        }
        return 1;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List listSubItems) {
        for (EnumEssentiaStorageTypes type : EnumEssentiaStorageTypes.fromIndex) {
            listSubItems.add(type.getCell());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTopTexture_Dark() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTopTexture_Light() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTopTexture_Medium() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1];
    }

    public String func_77658_a() {
        return "thaumicenergistics.item.essentia.cell";
    }

    public String func_77667_c(ItemStack itemStack) {
        return EnumEssentiaStorageTypes.fromIndex[itemStack.func_77960_j()].cellName.getUnlocalized();
    }

    public boolean isCell(ItemStack itemStack) {
        return itemStack.func_77973_b() == this;
    }

    public long maxStorage(ItemStack essentiaCell) {
        return EnumEssentiaStorageTypes.fromIndex[essentiaCell.func_77960_j()].capacity;
    }

    public int maxTypes(ItemStack essentiaCell) {
        return EnumEssentiaStorageTypes.fromIndex[essentiaCell.func_77960_j()].maxStoredTypes;
    }

    public ItemStack func_77659_a(ItemStack essentiaCell, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return essentiaCell;
        }
        if (essentiaCell.func_77960_j() == EnumEssentiaStorageTypes.Type_Creative.index) {
            return essentiaCell;
        }
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(essentiaCell, null, StorageChannel.FLUIDS);
        if (!(handler instanceof HandlerItemEssentiaCell)) {
            return essentiaCell;
        }
        HandlerItemEssentiaCell cellHandler = (HandlerItemEssentiaCell)handler;
        if (cellHandler.getUsedBytes() == 0L && player.field_71071_by.func_70441_a(ItemEnum.STORAGE_CASING.getStack())) {
            return EnumEssentiaStorageTypes.fromIndex[essentiaCell.func_77960_j()].getComponent(1);
        }
        return essentiaCell;
    }

    public void openChestGui(EntityPlayer player, IChestOrDrive chest, ICellHandler cellHandler, IMEInventoryHandler inv, ItemStack itemStack, StorageChannel channel) {
        IStorageMonitorable monitorable;
        if (channel != StorageChannel.FLUIDS) {
            return;
        }
        if (chest != null && (monitorable = ((IMEChest)chest).getMonitorable(ForgeDirection.UNKNOWN, (BaseActionSource)new PlayerSource(player, (IActionHost)chest))) != null) {
            TileEntity chestEntity = (TileEntity)chest;
            ThEGuiHandler.launchGui(10, player, chestEntity.func_145831_w(), chestEntity.field_145851_c, chestEntity.field_145848_d, chestEntity.field_145849_e);
        }
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[EnumEssentiaStorageTypes.fromIndex.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("thaumicenergistics:essentia.cell." + EnumEssentiaStorageTypes.fromIndex[i].suffix);
        }
    }
}

