/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ITerminalHost;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.helpers.IPriorityHost;
import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.api.gui.ICraftingIssuerContainer;
import thaumicenergistics.client.gui.GuiArcaneAssembler;
import thaumicenergistics.client.gui.GuiCraftAmountBridge;
import thaumicenergistics.client.gui.GuiCraftConfirmBridge;
import thaumicenergistics.client.gui.GuiDistillationPatternEncoder;
import thaumicenergistics.client.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.client.gui.GuiEssentiaCellWorkbench;
import thaumicenergistics.client.gui.GuiEssentiaVibrationChamber;
import thaumicenergistics.client.gui.GuiKnowledgeInscriber;
import thaumicenergistics.client.gui.GuiPriority;
import thaumicenergistics.common.ThaumicEnergistics;
import thaumicenergistics.common.container.ContainerArcaneAssembler;
import thaumicenergistics.common.container.ContainerDistillationPatternEncoder;
import thaumicenergistics.common.container.ContainerEssentiaCell;
import thaumicenergistics.common.container.ContainerEssentiaCellWorkbench;
import thaumicenergistics.common.container.ContainerEssentiaVibrationChamber;
import thaumicenergistics.common.container.ContainerKnowledgeInscriber;
import thaumicenergistics.common.container.ContainerPriority;
import thaumicenergistics.common.container.ContainerWirelessEssentiaTerminal;
import thaumicenergistics.common.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.common.parts.ThEPartBase;

public class ThEGuiHandler
implements IGuiHandler {
    private static final int DIRECTION_OFFSET = ForgeDirection.values().length;
    private static final int ID_STEP_VALUE = 10;
    public static final int ESSENTIA_CELL_ID = 10;
    public static final int PRIORITY_ID = 20;
    public static final int CELL_WORKBENCH_ID = 30;
    public static final int WIRELESS_TERMINAL_ID = 40;
    public static final int ARCANE_ASSEMBLER_ID = 50;
    public static final int KNOWLEDGE_INSCRIBER = 60;
    public static final int ESSENTIA_VIBRATION_CHAMBER = 70;
    public static final int AUTO_CRAFTING_AMOUNT = 80;
    public static final int AUTO_CRAFTING_CONFIRM = 90;
    public static final int DISTILLATION_ENCODER = 100;
    private static Object[] extraData = null;

    private static ICraftingIssuerHost getCraftingIssuerHost(EntityPlayer player) {
        Object target;
        if (player.field_71070_bA instanceof ICraftingIssuerContainer) {
            return ((ICraftingIssuerContainer)player.field_71070_bA).getCraftingHost();
        }
        if (player.field_71070_bA instanceof AEBaseContainer && (target = ((AEBaseContainer)player.field_71070_bA).getTarget()) instanceof ICraftingIssuerHost) {
            return (ICraftingIssuerHost)target;
        }
        return null;
    }

    private static IPart getPart(ForgeDirection tileSide, World world, int x, int y, int z) {
        IPartHost partHost = (IPartHost)world.func_147438_o(x, y, z);
        if (partHost == null) {
            return null;
        }
        return partHost.getPart(tileSide);
    }

    private static IPart getPartFromSidedID(int ID, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)(ID % 10));
        return ThEGuiHandler.getPart(side, world, x, y, z);
    }

    private static Object getPartGuiElement(ForgeDirection tileSide, EntityPlayer player, World world, int x, int y, int z, boolean isServerSide) {
        ThEPartBase part = (ThEPartBase)ThEGuiHandler.getPart(tileSide, world, x, y, z);
        if (part == null) {
            return null;
        }
        if (isServerSide) {
            return part.getServerGuiElement(player);
        }
        return part.getClientGuiElement(player);
    }

    private static boolean isIDInRange(int ID, int BaseID) {
        return ID >= BaseID && ID < BaseID + 10;
    }

    public static int generateSidedID(int ID, ForgeDirection side) {
        return ID + side.ordinal();
    }

    public static void launchGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)ThaumicEnergistics.INSTANCE, ID + DIRECTION_OFFSET, world, x, y, z);
    }

    public static void launchGui(int ID, EntityPlayer player, World world, int x, int y, int z, Object[] extraData) {
        ThEGuiHandler.extraData = extraData;
        player.openGui((Object)ThaumicEnergistics.INSTANCE, ID + DIRECTION_OFFSET, world, x, y, z);
        ThEGuiHandler.extraData = null;
    }

    public static void launchGui(ThEPartBase part, EntityPlayer player, World world, int x, int y, int z) {
        if (part.isPartUseableByPlayer(player)) {
            player.openGui((Object)ThaumicEnergistics.INSTANCE, part.getSide().ordinal(), world, x, y, z);
        }
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return ThEGuiHandler.getPartGuiElement(side, player, world, x, y, z, false);
        }
        switch (ID -= DIRECTION_OFFSET) {
            case 10: {
                return GuiEssentiaCellTerminal.NewEssentiaCellGui(player, world, x, y, z);
            }
            case 30: {
                return new GuiEssentiaCellWorkbench(player, world, x, y, z);
            }
            case 40: {
                return GuiEssentiaCellTerminal.NewWirelessEssentiaTerminalGui(player);
            }
            case 50: {
                return new GuiArcaneAssembler(player, world, x, y, z);
            }
            case 60: {
                return new GuiKnowledgeInscriber(player, world, x, y, z);
            }
            case 70: {
                return new GuiEssentiaVibrationChamber(player, world, x, y, z);
            }
            case 100: {
                return new GuiDistillationPatternEncoder(player, world, x, y, z);
            }
            case 80: {
                ICraftingIssuerHost amountHost = ThEGuiHandler.getCraftingIssuerHost(player);
                if (amountHost != null) {
                    return new GuiCraftAmountBridge(player, amountHost);
                }
                return null;
            }
            case 90: {
                ICraftingIssuerHost confirmHost = ThEGuiHandler.getCraftingIssuerHost(player);
                if (confirmHost != null) {
                    return new GuiCraftConfirmBridge(player, confirmHost);
                }
                return null;
            }
        }
        if (ThEGuiHandler.isIDInRange(ID, 20)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof IPriorityHost)) {
                return null;
            }
            return new GuiPriority((IPriorityHost)part, player);
        }
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return ThEGuiHandler.getPartGuiElement(side, player, world, x, y, z, true);
        }
        switch (ID -= DIRECTION_OFFSET) {
            case 10: {
                return new ContainerEssentiaCell(player, world, x, y, z);
            }
            case 30: {
                return new ContainerEssentiaCellWorkbench(player, world, x, y, z);
            }
            case 40: {
                HandlerWirelessEssentiaTerminal handler = (HandlerWirelessEssentiaTerminal)extraData[0];
                return new ContainerWirelessEssentiaTerminal(player, handler);
            }
            case 50: {
                return new ContainerArcaneAssembler(player, world, x, y, z);
            }
            case 60: {
                return new ContainerKnowledgeInscriber(player, world, x, y, z);
            }
            case 70: {
                return new ContainerEssentiaVibrationChamber(player, world, x, y, z);
            }
            case 100: {
                return new ContainerDistillationPatternEncoder(player, world, x, y, z);
            }
            case 80: {
                ICraftingIssuerHost amountHost = ThEGuiHandler.getCraftingIssuerHost(player);
                if (amountHost != null) {
                    return new ContainerCraftAmount(player.field_71071_by, (ITerminalHost)amountHost);
                }
                return null;
            }
            case 90: {
                ICraftingIssuerHost confirmHost = ThEGuiHandler.getCraftingIssuerHost(player);
                if (confirmHost != null) {
                    return new ContainerCraftConfirm(player.field_71071_by, (ITerminalHost)confirmHost);
                }
                return null;
            }
        }
        if (ThEGuiHandler.isIDInRange(ID, 20)) {
            IPart part = ThEGuiHandler.getPartFromSidedID(ID, world, x, y, z);
            if (part == null || !(part instanceof IPriorityHost)) {
                return null;
            }
            return new ContainerPriority((IPriorityHost)part, player);
        }
        return null;
    }
}

