/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration;

import appeng.api.networking.IGrid;
import appeng.me.GridAccessException;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.IEssentiaGrid;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.api.grid.IMEEssentiaMonitorReceiver;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.integration.IEssentiaProviderWatcher;
import thaumicenergistics.common.tiles.TileEssentiaProvider;

public class EssentiaProviderPeripheral
implements IPeripheral,
IEssentiaProviderWatcher {
    private static final String CC_PERIPHERAL_NAME = "EssentiaProvider";
    private static final String CC_EVENT_NAME = "essentia";
    private static final Hashtable<String, Aspect> aspectNameReverseMap = new Hashtable();
    private final WeakReference<World> epWorld;
    private final int epX;
    private final int epY;
    private final int epZ;
    private final EssentiaWatcher watcher;
    private final HashSet<IComputerAccess> attachedComputers = new HashSet();
    private boolean isRegisteredAsBlockListener = false;

    public EssentiaProviderPeripheral(World world, int x, int y, int z) {
        this.epWorld = new WeakReference<World>(world);
        this.epX = x;
        this.epY = y;
        this.epZ = z;
        this.watcher = new EssentiaWatcher();
        this.getProvider();
    }

    private Object[] ccGetAmount(Object[] args) throws LuaException, InterruptedException {
        TileEssentiaProvider provider = this.getProvider();
        List<Aspect> aspects = this.getAspectsFromArguments(args);
        Object[] results = new Object[aspects.size()];
        boolean providerActive = provider != null ? provider.isActive() : false;
        for (int index = 0; index < results.length; ++index) {
            results[index] = providerActive ? (Number)provider.getAspectAmountInNetwork(aspects.get(index)) : (Number)0;
        }
        return results;
    }

    private Object[] ccGetAspects() throws LuaException, InterruptedException {
        IMEEssentiaMonitor monitor = this.getProviderMonitor();
        if (monitor == null) {
            return null;
        }
        Collection<IAspectStack> essentiaList = monitor.getEssentiaList();
        if (essentiaList.size() == 0) {
            return null;
        }
        Object[] ccList = new Object[essentiaList.size() * 2];
        int index = 0;
        for (IAspectStack stack : essentiaList) {
            ccList[index] = stack.getAspectName();
            ccList[index + 1] = stack.getStackSize();
            index += 2;
        }
        return ccList;
    }

    private Object[] ccGetOnline() throws LuaException, InterruptedException {
        return new Object[]{this.isProviderAvailable()};
    }

    private boolean ccRegisterAsWatcher(IComputerAccess computer, Object[] args) throws LuaException, InterruptedException {
        if (!this.isProviderAvailable()) {
            return false;
        }
        if (args != null && args.length > 0) {
            HashSet<Aspect> aspects = new HashSet<Aspect>(this.getAspectsFromArguments(args));
            this.watcher.addComputerWatch(computer, aspects);
        } else {
            this.watcher.addComputerWatch(computer, null);
        }
        return true;
    }

    private Aspect getAspectFromName(String name) {
        String aspectName = name.toLowerCase();
        if (aspectNameReverseMap.contains(aspectName)) {
            return aspectNameReverseMap.get(aspectName);
        }
        for (Aspect searchAspect : Aspect.aspects.values()) {
            if (!searchAspect.getName().equalsIgnoreCase(aspectName)) continue;
            aspectNameReverseMap.put(aspectName, searchAspect);
            return searchAspect;
        }
        return null;
    }

    private List<Aspect> getAspectsFromArguments(Object[] args) throws LuaException, InterruptedException {
        if (args == null || args.length == 0) {
            throw new LuaException("Expected argument: <string>AspectName");
        }
        ArrayList<Aspect> results = new ArrayList<Aspect>();
        for (Object arg : args) {
            Aspect aspect;
            if (arg instanceof String) {
                aspect = this.getAspectFromName((String)arg);
                if (aspect == null) {
                    throw new LuaException(String.format("Invalid aspect name '%s'", arg));
                }
            } else {
                throw new LuaException(String.format("Invalid argument '%s'", arg));
            }
            results.add(aspect);
        }
        return results;
    }

    private boolean isProviderAvailable() {
        TileEssentiaProvider provider = this.getProvider();
        return provider != null ? provider.isActive() : false;
    }

    TileEssentiaProvider getProvider() {
        World world;
        if (this.epWorld == null || (world = (World)this.epWorld.get()) == null) {
            return null;
        }
        TileEntity te = world.func_147438_o(this.epX, this.epY, this.epZ);
        if (te instanceof TileEssentiaProvider) {
            if (!this.isRegisteredAsBlockListener) {
                ((TileEssentiaProvider)te).registerBlockWatcher(this);
                this.isRegisteredAsBlockListener = true;
            }
            return (TileEssentiaProvider)te;
        }
        return null;
    }

    IMEEssentiaMonitor getProviderMonitor() throws LuaException, InterruptedException {
        TileEssentiaProvider provider = this.getProvider();
        if (!provider.isActive()) {
            return null;
        }
        try {
            return (IMEEssentiaMonitor)provider.getActionableNode().getGrid().getCache(IEssentiaGrid.class);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    void sendEvent(IComputerAccess computer, CCEvents event, Object ... additionalData) {
        Object[] args = new Object[additionalData == null ? 1 : 1 + additionalData.length];
        args[0] = event.eventID;
        if (additionalData != null) {
            System.arraycopy(additionalData, 0, args, 1, additionalData.length);
        }
        computer.queueEvent(CC_EVENT_NAME, args);
    }

    public void attach(IComputerAccess computer) {
        this.attachedComputers.add(computer);
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        Object[] results = null;
        switch (CCMethods.VALUES[method]) {
            case isOnline: {
                results = this.ccGetOnline();
                break;
            }
            case getAspects: {
                results = this.ccGetAspects();
                break;
            }
            case getAmount: {
                results = this.ccGetAmount(arguments);
                break;
            }
            case registerAsWatcher: {
                results = new Object[]{this.ccRegisterAsWatcher(computer, arguments)};
                break;
            }
            case unregisterAsWatcher: {
                this.watcher.removeComputerWatcher(computer);
                results = new Object[]{true};
                break;
            }
            case help: {
                results = new Object[]{CCHelpObject.Instance()};
            }
        }
        return results;
    }

    public void detach(IComputerAccess computer) {
        this.attachedComputers.remove(computer);
        this.watcher.removeComputerWatcher(computer);
        this.sendEvent(computer, CCEvents.Detached, new Object[0]);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public String[] getMethodNames() {
        return CCMethods.NAMES;
    }

    public String getType() {
        return CC_PERIPHERAL_NAME;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void onProviderBroken() {
        this.isRegisteredAsBlockListener = false;
        for (IComputerAccess computer : this.attachedComputers) {
            this.sendEvent(computer, CCEvents.PowerChange, false);
        }
        this.watcher.onProviderBroken();
    }

    @Override
    public void onProviderPowerChange(boolean isOnline) {
        for (IComputerAccess computer : this.attachedComputers) {
            this.sendEvent(computer, CCEvents.PowerChange, isOnline);
        }
    }

    private class EssentiaWatcher
    implements IMEEssentiaMonitorReceiver {
        private final HashMap<IComputerAccess, Boolean> computerWatchers;
        private final HashMap<Aspect, Set<IComputerAccess>> aspectWatchers;
        private final HashSet<IComputerAccess> anyWatchers;
        private final Object threadLock = new Object();
        private boolean isReceving = false;

        public EssentiaWatcher() {
            this.computerWatchers = new HashMap();
            this.aspectWatchers = new HashMap();
            this.anyWatchers = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComputerWatch(IComputerAccess computer, Set<Aspect> aspectsOfInterest) throws LuaException, InterruptedException {
            Object object = this.threadLock;
            synchronized (object) {
                IMEEssentiaMonitor monitor;
                if (this.computerWatchers.containsKey(computer) && this.computerWatchers.get(computer).booleanValue()) {
                    this.removeComputerWatcher(computer);
                }
                boolean specificWatches = false;
                if (aspectsOfInterest != null && aspectsOfInterest.size() > 0) {
                    specificWatches = true;
                    for (Aspect watchAspect : aspectsOfInterest) {
                        if (!this.aspectWatchers.containsKey(watchAspect)) {
                            this.aspectWatchers.put(watchAspect, new HashSet());
                        }
                        this.aspectWatchers.get(watchAspect).add(computer);
                    }
                } else {
                    this.anyWatchers.add(computer);
                }
                this.computerWatchers.put(computer, specificWatches);
                if (!this.isReceving && (monitor = EssentiaProviderPeripheral.this.getProviderMonitor()) != null) {
                    try {
                        monitor.addListener(this, EssentiaProviderPeripheral.this.getProvider().getProxy().getGrid());
                        this.isReceving = true;
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid(Object verificationToken) {
            block5: {
                this.isReceving = false;
                try {
                    IGrid grid = EssentiaProviderPeripheral.this.getProvider().getProxy().getGrid();
                    if (verificationToken != grid) break block5;
                    Object object = this.threadLock;
                    synchronized (object) {
                        this.isReceving = this.computerWatchers.size() > 0;
                    }
                }
                catch (GridAccessException e) {
                    return false;
                }
            }
            return this.isReceving;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProviderBroken() {
            Object object = this.threadLock;
            synchronized (object) {
                this.anyWatchers.clear();
                this.aspectWatchers.clear();
                this.computerWatchers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void postChange(IMEEssentiaMonitor fromMonitor, Iterable<IAspectStack> changes) {
            TileEssentiaProvider provider = EssentiaProviderPeripheral.this.getProvider();
            if (provider == null) {
                this.onProviderBroken();
                return;
            }
            if (!provider.isActive()) {
                return;
            }
            Object object = this.threadLock;
            synchronized (object) {
                HashSet<IComputerAccess> invalidWatchers = null;
                Object[] ccChange = null;
                for (IAspectStack change : changes) {
                    Set<IComputerAccess> specificWatchers;
                    if (this.anyWatchers.size() > 0) {
                        ccChange = new Object[]{change.getAspectName(), change.getStackSize()};
                        for (IComputerAccess computer : this.anyWatchers) {
                            try {
                                EssentiaProviderPeripheral.this.sendEvent(computer, CCEvents.AspectUpdate, ccChange);
                            }
                            catch (Exception e) {
                                if (invalidWatchers == null) {
                                    invalidWatchers = new HashSet<IComputerAccess>();
                                }
                                invalidWatchers.add(computer);
                            }
                        }
                    }
                    if ((specificWatchers = this.aspectWatchers.get(change.getAspect())) == null) continue;
                    ccChange = new Object[]{change.getAspectName(), change.getStackSize()};
                    for (IComputerAccess computer : specificWatchers) {
                        try {
                            EssentiaProviderPeripheral.this.sendEvent(computer, CCEvents.AspectUpdate, ccChange);
                        }
                        catch (Exception e) {
                            if (invalidWatchers == null) {
                                invalidWatchers = new HashSet();
                            }
                            invalidWatchers.add(computer);
                        }
                    }
                }
                if (invalidWatchers != null) {
                    for (IComputerAccess badComputer : invalidWatchers) {
                        this.removeComputerWatcher(badComputer);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComputerWatcher(IComputerAccess computer) {
            Object object = this.threadLock;
            synchronized (object) {
                if (this.computerWatchers.containsKey(computer)) {
                    if (this.computerWatchers.get(computer).booleanValue()) {
                        for (Set<IComputerAccess> watchSet : this.aspectWatchers.values()) {
                            watchSet.remove(computer);
                        }
                    } else {
                        this.anyWatchers.remove(computer);
                    }
                    this.computerWatchers.remove(computer);
                }
            }
        }
    }

    private static enum CCEvents {
        AspectUpdate(1),
        PowerChange(2),
        Detached(3);

        public final int eventID;

        private CCEvents(int ID) {
            this.eventID = ID;
        }
    }

    private static enum CCMethods {
        isOnline,
        getAspects,
        getAmount,
        registerAsWatcher,
        unregisterAsWatcher,
        help;

        public static final CCMethods[] VALUES;
        public static final String[] NAMES;

        static {
            VALUES = CCMethods.values();
            NAMES = new String[VALUES.length];
            for (int i = 0; i < NAMES.length; ++i) {
                CCMethods.NAMES[i] = VALUES[i].name();
            }
        }
    }

    private static class CCHelpObject
    implements ILuaObject {
        private static CCHelpObject INSTANCE;

        private CCHelpObject() {
        }

        public static CCHelpObject Instance() {
            if (INSTANCE == null) {
                INSTANCE = new CCHelpObject();
            }
            return INSTANCE;
        }

        public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            String helpText = null;
            if (method == 6) {
                helpText = "\nEvent name: essentia\nEvent Structure: [Index] [Arg1] [Arg2]\n\nEssentia Event:[1] [aspectName] [changeAmount]\nPower Event:   [2] [true(on)|false(off)]\nDetach Event:  [3]\n\nExample:\nevent = { os.pullEvent(\"essentia\") }\n";
            } else {
                switch (CCMethods.VALUES[method]) {
                    case isOnline: {
                        helpText = "\nNo arguments.\nReturns true if the provider is powered on and connected, false otherwise.\n\nExample:\nif( ep.isOnline() ) then\n";
                        break;
                    }
                    case getAspects: {
                        helpText = "\nNo arguments.\nReturns the name then the amount of each essentia type stored.\nNote: You will probably want to wrap the results into a table.\n\nExample:\nessTable = {ep.getAspects()}\nname = essTable[1]\namount = essTable[2]\n";
                        break;
                    }
                    case getAmount: {
                        helpText = "\nArguments: AspectName1, AspectName2, ...\nReturns the amount(s) of essentia stored in the system for the specified aspect(s).\n\nExample:\nordoAmt = ep.getAmount(\"ordo\")\nordoAmt, metoAmt = ep.getAmount(\"ordo\",\"meto\")\n";
                        break;
                    }
                    case registerAsWatcher: {
                        helpText = "\nOptional Arguments: AspectName1, AspectName2, ...\nRegisters this computer for essentia events. When essentia amounts on the network changes, this computer will receive a notification event.\nIf aspect arguments are provided, only events for those aspects will be generated. If no arguments are provided, any change will generate an event.\nNote: Run help.events() for details about the events.\n\nExamples:\nep.registerAsWatcher()\nep.registerAsWatcher(\"ordo\")\nep.registerAsWatcher(\"ordo\",\"meto\")\n";
                        break;
                    }
                    case unregisterAsWatcher: {
                        helpText = "\nOptional Arguments: AspectName1, AspectName2, ...\nUnregisters this computer for essentia events.\nIf aspect arguments are provided, only unregister for those aspects. If no arguments are provided, unregister for all.\n\nExamples:\nep.unregisterAsWatcher()\nep.unregisterAsWatcher(\"ordo\")\nep.unregisterAsWatcher(\"meto\",\"ordo\")\n";
                        break;
                    }
                    case help: {
                        helpText = "\nDisplays help for the following:\n" + StringUtils.join((Object[])new Serializable[]{"()\n", this.getMethodNames()}) + "()\n";
                    }
                }
            }
            return new Object[]{helpText};
        }

        public String[] getMethodNames() {
            int staticLen = CCMethods.NAMES.length;
            String[] names = new String[staticLen + 1];
            System.arraycopy(CCMethods.NAMES, 0, names, 0, staticLen);
            names[staticLen] = "events";
            return names;
        }
    }
}

