/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common;

import appeng.api.AEApi;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.grid.IEssentiaGrid;
import thaumicenergistics.common.CommonProxy;
import thaumicenergistics.common.ConfigurationHandler;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.entities.WirelessGolemHandler;
import thaumicenergistics.common.grid.GridEssentiaCache;
import thaumicenergistics.common.integration.IntegrationCore;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.integration.tc.EssentiaTileContainerHelper;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.registries.AEAspectRegister;
import thaumicenergistics.common.utils.ThELog;

@Mod(modid="thaumicenergistics", name="Thaumic Energistics", version="1.3.16-GTNH", dependencies="required-after:ThE-core;required-after:appliedenergistics2@[rv3-beta-23,);required-after:Thaumcraft@[4.2.3.5,);after:Waila;after:extracells")
public class ThaumicEnergistics {
    private static LoaderState ThEState = LoaderState.NOINIT;
    public static final String MOD_ID = "thaumicenergistics";
    public static final String VERSION = "1.3.16-GTNH";
    @Mod.Instance(value="thaumicenergistics")
    public static ThaumicEnergistics INSTANCE;
    @SidedProxy(clientSide="thaumicenergistics.client.ClientProxy", serverSide="thaumicenergistics.common.CommonProxy")
    public static CommonProxy proxy;
    public static IThEConfig config;
    public static CreativeTabs ThETab;

    public static LoaderState getLoaderState() {
        return ThEState;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        long startTime = ThELog.beginSection("Load");
        proxy.registerRenderers();
        proxy.registerTileEntities();
        NetworkHandler.registerPackets();
        IntegrationCore.init();
        AEApi.instance().registries().gridCache().registerGridCache(IEssentiaGrid.class, GridEssentiaCache.class);
        ThEApi.instance().interact().registerGolemHookHandler(WirelessGolemHandler.getInstance());
        ThELog.endSection("Load", startTime);
        ThEState = LoaderState.INITIALIZATION;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        long startTime = ThELog.beginSection("PostInit");
        EssentiaTileContainerHelper.INSTANCE.registerDefaultContainers();
        EssentiaItemContainerHelper.INSTANCE.registerDefaultContainers();
        proxy.registerFeatures();
        proxy.registerSpatialIOMovables();
        proxy.registerFluids();
        try {
            AEAspectRegister.INSTANCE.registerAEAspects();
        }
        catch (Exception e) {
            ThELog.warning("Unable to finish aspect registration due to exception:%n%s%n", e.getMessage());
        }
        ThELog.endSection("PostInit", startTime);
        ThEState = LoaderState.POSTINITIALIZATION;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        long startTime = ThELog.beginSection("PreInit");
        INSTANCE = this;
        config = ConfigurationHandler.loadAndSyncConfigFile(event.getSuggestedConfigurationFile());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ThEGuiHandler());
        proxy.registerItems();
        proxy.registerBlocks();
        ThELog.endSection("PreInit", startTime);
        ThEState = LoaderState.PREINITIALIZATION;
    }

    static {
        ThETab = new CreativeTabs("ThaumicEnergistics"){

            public ItemStack func_151244_d() {
                return ThEApi.instance().blocks().InfusionProvider.getStack();
            }

            public Item func_78016_d() {
                return ThEApi.instance().blocks().InfusionProvider.getItem();
            }
        };
    }
}

