/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.helpers.IPriorityHost;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import thaumicenergistics.common.network.packet.client.Packet_C_Priority;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.utils.ThEUtils;

public class ContainerPriority
extends Container {
    public final IPriorityHost host;
    private final EntityPlayer player;

    public ContainerPriority(IPriorityHost host, EntityPlayer player) {
        this.host = host;
        this.player = player;
    }

    private void sendPriorityToClient() {
        Packet_C_Priority.sendPriority(this.host.getPriority(), this.player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.host instanceof IInventory) {
            return ((IInventory)this.host).func_70300_a(player);
        }
        if (this.host instanceof ThEPartBase) {
            return ((ThEPartBase)this.host).isPartUseableByPlayer(player);
        }
        if (this.host instanceof TileEntity) {
            return ThEUtils.canPlayerInteractWith(player, (TileEntity)this.host);
        }
        return false;
    }

    public void onClientRequestAdjustPriority(int adjustment) {
        int newPriority = this.host.getPriority() + adjustment;
        this.onClientRequestSetPriority(newPriority);
    }

    public void onClientRequestPriority() {
        this.sendPriorityToClient();
    }

    public void onClientRequestSetPriority(int newPriority) {
        this.host.setPriority(newPriority);
        this.sendPriorityToClient();
    }
}

