/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.config.Upgrades;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.parts.PartArcaneCraftingTerminal;
import thaumicenergistics.common.parts.PartEssentiaConversionMonitor;
import thaumicenergistics.common.parts.PartEssentiaExportBus;
import thaumicenergistics.common.parts.PartEssentiaImportBus;
import thaumicenergistics.common.parts.PartEssentiaLevelEmitter;
import thaumicenergistics.common.parts.PartEssentiaStorageBus;
import thaumicenergistics.common.parts.PartEssentiaStorageMonitor;
import thaumicenergistics.common.parts.PartEssentiaTerminal;
import thaumicenergistics.common.parts.PartVisInterface;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.registries.ThEStrings;

public enum AEPartsEnum {
    EssentiaImportBus(ThEStrings.Part_EssentiaImportBus, PartEssentiaImportBus.class, "thaumicenergistics.group.essentia.transport", AEPartsEnum.generatePair(Upgrades.CAPACITY, 2), AEPartsEnum.generatePair(Upgrades.REDSTONE, 1), AEPartsEnum.generatePair(Upgrades.SPEED, 2)),
    EssentiaLevelEmitter(ThEStrings.Part_EssentiaLevelEmitter, PartEssentiaLevelEmitter.class),
    EssentiaStorageBus(ThEStrings.Part_EssentiaStorageBus, PartEssentiaStorageBus.class, null, AEPartsEnum.generatePair(Upgrades.INVERTER, 1)),
    EssentiaExportBus(ThEStrings.Part_EssentiaExportBus, PartEssentiaExportBus.class, "thaumicenergistics.group.essentia.transport", AEPartsEnum.generatePair(Upgrades.CAPACITY, 2), AEPartsEnum.generatePair(Upgrades.REDSTONE, 1), AEPartsEnum.generatePair(Upgrades.SPEED, 2), AEPartsEnum.generatePair(Upgrades.CRAFTING, 1)),
    EssentiaTerminal(ThEStrings.Part_EssentiaTerminal, PartEssentiaTerminal.class),
    ArcaneCraftingTerminal(ThEStrings.Part_ArcaneCraftingTerminal, PartArcaneCraftingTerminal.class),
    VisInterface(ThEStrings.Part_VisRelayInterface, PartVisInterface.class),
    EssentiaStorageMonitor(ThEStrings.Part_EssentiaStorageMonitor, PartEssentiaStorageMonitor.class),
    EssentiaConversionMonitor(ThEStrings.Part_EssentiaConversionMonitor, PartEssentiaConversionMonitor.class);

    public static final AEPartsEnum[] VALUES;
    private ThEStrings unlocalizedName;
    private Class<? extends ThEPartBase> partClass;
    private String groupName;
    private Map<Upgrades, Integer> upgrades = new HashMap<Upgrades, Integer>();

    private AEPartsEnum(ThEStrings unlocalizedName, Class<? extends ThEPartBase> partClass) {
        this(unlocalizedName, partClass, null);
    }

    private AEPartsEnum(ThEStrings unlocalizedName, Class<? extends ThEPartBase> partClass, String groupName) {
        this.unlocalizedName = unlocalizedName;
        this.partClass = partClass;
        this.groupName = groupName;
    }

    private AEPartsEnum(ThEStrings unlocalizedName, Class<? extends ThEPartBase> partClass, String groupName, Pair<Upgrades, Integer> ... upgrades) {
        this(unlocalizedName, partClass, groupName);
        for (Pair<Upgrades, Integer> pair : upgrades) {
            this.upgrades.put((Upgrades)pair.getKey(), (Integer)pair.getValue());
        }
    }

    private static Pair<Upgrades, Integer> generatePair(Upgrades upgrade, int maximum) {
        return new ImmutablePair((Object)upgrade, (Object)maximum);
    }

    public static AEPartsEnum getPartFromDamageValue(ItemStack itemStack) {
        int clamped = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(VALUES.length - 1));
        return VALUES[clamped];
    }

    public static int getPartID(Class<? extends ThEPartBase> partClass) {
        int id = -1;
        for (int i = 0; i < VALUES.length; ++i) {
            if (!VALUES[i].getPartClass().equals(partClass)) continue;
            id = i;
            break;
        }
        return id;
    }

    public ThEPartBase createPartInstance(ItemStack itemStack) throws InstantiationException, IllegalAccessException {
        ThEPartBase part = this.partClass.newInstance();
        part.setupPartFromItem(itemStack);
        return part;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getLocalizedName() {
        return this.unlocalizedName.getLocalized();
    }

    public Class<? extends ThEPartBase> getPartClass() {
        return this.partClass;
    }

    public ItemStack getStack() {
        return ItemEnum.ITEM_AEPART.getDMGStack(this.ordinal());
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName.getUnlocalized();
    }

    public Map<Upgrades, Integer> getUpgrades() {
        return this.upgrades;
    }

    static {
        VALUES = AEPartsEnum.values();
    }
}

