/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.helpers.IPriorityHost;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.client.gui.GuiEssentiaStorageBus;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.container.ContainerPartEssentiaStorageBus;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.inventory.HandlerEssentiaStorageBusBase;
import thaumicenergistics.common.inventory.HandlerEssentiaStorageBusDuality;
import thaumicenergistics.common.network.IAspectSlotPart;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.utils.EffectiveSide;

public class PartEssentiaStorageBus
extends ThEPartBase
implements IGridTickable,
ICellContainer,
IAspectSlotPart,
IAEAppEngInventory,
IPriorityHost {
    public static final int FILTER_SIZE = 9;
    private static final double IDLE_POWER_DRAIN = 1.0;
    private static final String NBT_KEY_PRIORITY = "Priority";
    private static final String NBT_KEY_FILTER = "FilterAspects#";
    private static final String NBT_KEY_UPGRADES = "UpgradeInventory";
    private static final String NBT_KEY_VOID = "IsVoidAllowed";
    private final HandlerEssentiaStorageBusBase handler = new HandlerEssentiaStorageBusDuality(this);
    private final ArrayList<Aspect> filteredAspects = new ArrayList(9);
    private final UpgradeInventory upgradeInventory = new StackUpgradeInventory(this.associatedItem, (IAEAppEngInventory)this, 1);
    private int priority = 0;

    public PartEssentiaStorageBus() {
        super(AEPartsEnum.EssentiaStorageBus, SecurityPermissions.EXTRACT, SecurityPermissions.INJECT);
        for (int index = 0; index < 9; ++index) {
            this.filteredAspects.add(null);
        }
    }

    private void updateInverterState() {
        boolean inverted = AEApi.instance().definitions().materials().cardInverter().isSameAs(this.upgradeInventory.func_70301_a(0));
        this.handler.setInverted(inverted);
    }

    public boolean addFilteredAspectFromItemstack(EntityPlayer player, ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(itemStack);
        if (itemAspect != null) {
            if (this.filteredAspects.contains(itemAspect)) {
                return true;
            }
            for (int index = 0; index < 9; ++index) {
                if (this.filteredAspects.get(index) != null) continue;
                this.setAspect(index, itemAspect, player);
                return true;
            }
        }
        return false;
    }

    public void blinkCell(int slot) {
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    public boolean extractPowerForEssentiaTransfer(int essentiaAmount, Actionable mode) {
        IEnergyGrid eGrid = this.getGridBlock().getEnergyGrid();
        if (eGrid == null) {
            return false;
        }
        double powerDrain = 0.3 * (double)essentiaAmount;
        return eGrid.extractAEPower(powerDrain, mode, PowerMultiplier.CONFIG) >= powerDrain;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(1.0, 1.0, 15.0, 15.0, 15.0, 16.0);
        helper.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 15.0);
        helper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[0];
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (channel == StorageChannel.FLUIDS) {
            list.add(this.handler);
        }
        return list;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiEssentiaStorageBus(this, player);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        ItemStack slotStack = this.upgradeInventory.func_70301_a(0);
        if (slotStack != null && slotStack.field_77994_a > 0) {
            drops.add(slotStack);
        }
    }

    @Nullable
    public Aspect getFilteredAspect(int slotIndex) {
        return this.filteredAspects.get(slotIndex);
    }

    @Override
    public double getIdlePowerUsage() {
        return 1.0;
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartEssentiaStorageBus(this, player);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(20, 20, false, false);
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public boolean isVoidAllowed() {
        return this.handler.isVoidAllowed();
    }

    public void onChangeInventory(IInventory inv, int arg1, InvOperation arg2, ItemStack arg3, ItemStack arg4) {
        this.updateInverterState();
    }

    public void onClientRequestSetVoidMode(EntityPlayer player, boolean isVoidAllowed) {
        this.handler.setVoidAllowed(isVoidAllowed);
        this.saveChanges();
    }

    @Override
    public void onNeighborChanged() {
        if (EffectiveSide.isServerSide() && this.isActive() && this.handler.onNeighborChange()) {
            this.postGridUpdateEvent();
        }
    }

    public void postGridUpdateEvent() {
        IGrid grid;
        if (this.getActionableNode() != null && (grid = this.getActionableNode().getGrid()) != null) {
            grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_PRIORITY)) {
            this.priority = data.func_74762_e(NBT_KEY_PRIORITY);
        }
        for (int index = 0; index < 9; ++index) {
            if (data.func_74764_b(NBT_KEY_FILTER + index)) {
                this.filteredAspects.set(index, (Aspect)Aspect.aspects.get(data.func_74779_i(NBT_KEY_FILTER + index)));
                continue;
            }
            this.filteredAspects.set(index, null);
        }
        if (data.func_74764_b(NBT_KEY_UPGRADES)) {
            this.upgradeInventory.readFromNBT(data, NBT_KEY_UPGRADES);
            this.updateInverterState();
        }
        if (data.func_74764_b(NBT_KEY_VOID)) {
            this.handler.setVoidAllowed(data.func_74767_n(NBT_KEY_VOID));
        }
        this.handler.setPrioritizedAspects(this.filteredAspects);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[2];
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[0], side, side);
        helper.setBounds(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        helper.setInvColor(ThEPartBase.INVENTORY_OVERLAY_COLOR);
        ts.func_78380_c(0xF000F0);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[2];
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_STORAGE_BUS.getTexture(), side, side);
        helper.setBounds(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        tessellator.func_78378_d(this.getHost().getColor().blackVariant);
        if (this.isActive()) {
            tessellator.func_78380_c(0xD000D0);
        }
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    public void saveChanges() {
        this.markForSave();
    }

    public void saveChanges(IMEInventory inventory) {
        this.saveChanges();
    }

    @Override
    public void setAspect(int index, Aspect aspect, EntityPlayer player) {
        this.filteredAspects.set(index, aspect);
        if (EffectiveSide.isServerSide()) {
            this.handler.setPrioritizedAspects(this.filteredAspects);
            this.postGridUpdateEvent();
            this.markForSave();
        }
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.postGridUpdateEvent();
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.handler.tickingRequest(node, TicksSinceLastCall);
        return TickRateModulation.SAME;
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType != PartItemStack.World && saveType != PartItemStack.Wrench) {
            return;
        }
        boolean hasFilters = false;
        for (int index = 0; index < 9; ++index) {
            Aspect aspect = this.filteredAspects.get(index);
            if (aspect == null) continue;
            data.func_74778_a(NBT_KEY_FILTER + index, aspect.getTag());
            hasFilters = true;
        }
        if (hasFilters || saveType == PartItemStack.World) {
            if (this.priority != 0) {
                data.func_74768_a(NBT_KEY_PRIORITY, this.priority);
            }
            if (this.handler.isVoidAllowed()) {
                data.func_74757_a(NBT_KEY_VOID, this.handler.isVoidAllowed());
            }
        }
        if (saveType == PartItemStack.World && !this.upgradeInventory.isEmpty()) {
            this.upgradeInventory.writeToNBT(data, NBT_KEY_UPGRADES);
        }
    }
}

