/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration;

import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.INEIGuiAdapter;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.IRecipeHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumicenergistics.client.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.client.gui.abstraction.ThEBaseGui;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.packet.server.Packet_S_NEIRecipe;

public class ModuleNEI {
    static final int NEI_REGULAR_SLOT_OFFSET_X = 25;
    static final int NEI_REGULAR_SLOT_OFFSET_Y = 6;

    public ModuleNEI() throws Exception {
        API.registerGuiOverlay(GuiArcaneCraftingTerminal.class, (String)"crafting", (IStackPositioner)new ACTSlotPositioner());
        ACTOverlayHandler craftingOverlayHandler = new ACTOverlayHandler(false);
        ACTOverlayHandler arcaneOverlayHandler = new ACTOverlayHandler(true);
        API.registerGuiOverlayHandler(GuiArcaneCraftingTerminal.class, (IOverlayHandler)craftingOverlayHandler, (String)"crafting");
        API.registerGuiOverlayHandler(GuiArcaneCraftingTerminal.class, (IOverlayHandler)arcaneOverlayHandler, (String)"arcaneshapedrecipes");
        API.registerGuiOverlayHandler(GuiArcaneCraftingTerminal.class, (IOverlayHandler)arcaneOverlayHandler, (String)"arcaneshapelessrecipes");
        API.registerNEIGuiHandler((INEIGuiHandler)new NEIGuiHandler());
        API.hideItem((ItemStack)ItemEnum.CRAFTING_ASPECT.getStack());
    }

    static class NEIGuiHandler
    extends INEIGuiAdapter {
        NEIGuiHandler() {
        }

        public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
            if (gui instanceof ThEBaseGui && draggedStack != null && draggedStack.func_77973_b() != null) {
                ((ThEBaseGui)gui).field_147012_x = draggedStack;
                draggedStack.field_77994_a = 0;
            }
            return super.handleDragNDrop(gui, mousex, mousey, draggedStack, button);
        }
    }

    public static class ACTSlotPositioner
    implements IStackPositioner {
        public ArrayList<PositionedStack> positionStacks(ArrayList<PositionedStack> stacks) {
            for (PositionedStack ps : stacks) {
                if (ps == null) continue;
                ps.relx += ContainerPartArcaneCraftingTerminal.CRAFTING_SLOT_X_POS - 25;
                ps.rely += ContainerPartArcaneCraftingTerminal.CRAFTING_SLOT_Y_POS - 6;
            }
            return stacks;
        }
    }

    static class ACTOverlayHandler
    implements IOverlayHandler {
        private static final int REGULAR_SLOT_INDEX_DIVISOR = 18;
        private static final int ARCANE_SLOTY_INDEX_DIVISOR = 20;
        private final boolean isArcaneHandler;

        public final void overlayRecipe(GuiContainer gui, IRecipeHandler recipeHandler, int recipeIndex, boolean shift) {
            try {
                if (gui instanceof GuiArcaneCraftingTerminal) {
                    List ingredients = recipeHandler.getIngredientStacks(recipeIndex);
                    NBTTagCompound recipe = new NBTTagCompound();
                    for (PositionedStack ingredient : ingredients) {
                        if (ingredient == null || ingredient.item == null || ingredient.item.func_77973_b() == null) continue;
                        this.addIngredientToItems(ingredient, recipe, false);
                    }
                    if (this.testSize(recipe, 32768)) {
                        recipe = new NBTTagCompound();
                        for (PositionedStack ingredient : ingredients) {
                            if (ingredient == null || ingredient.item == null || ingredient.item.func_77973_b() == null) continue;
                            this.addIngredientToItems(ingredient, recipe, true);
                        }
                    }
                    Packet_S_NEIRecipe packet = new Packet_S_NEIRecipe();
                    packet.setRecipe(recipe);
                    packet.player = Minecraft.func_71410_x().field_71439_g;
                    NetworkHandler.sendPacketToServer(packet);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ACTOverlayHandler(boolean isArcane) {
            this.isArcaneHandler = isArcane;
        }

        private void packIngredient(NBTTagCompound recipe, int slotIndex, PositionedStack positionedStack, boolean limited) throws IOException {
            NBTTagList tags = new NBTTagList();
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int x = 0; x < positionedStack.items.length; ++x) {
                if (Platform.isRecipePrioritized((ItemStack)positionedStack.items[x])) {
                    list.add(0, positionedStack.items[x]);
                    continue;
                }
                list.add(positionedStack.items[x]);
            }
            for (ItemStack is : list) {
                NBTTagCompound tag = new NBTTagCompound();
                is.func_77955_b(tag);
                tags.func_74742_a((NBTBase)tag);
                if (!limited) continue;
                NBTTagCompound test = new NBTTagCompound();
                test.func_74782_a("#" + slotIndex, (NBTBase)tags);
                if (!this.testSize(test, 3072)) continue;
                break;
            }
            recipe.func_74782_a("#" + slotIndex, (NBTBase)tags);
        }

        protected boolean testSize(NBTTagCompound recipe, int limit) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bytes);
            CompressedStreamTools.func_74799_a((NBTTagCompound)recipe, (OutputStream)outputStream);
            return bytes.size() > limit;
        }

        private boolean addArcaneCraftingItems(PositionedStack ingredient, NBTTagCompound recipe, boolean limited) throws IOException {
            int slotIndex;
            int slotX = (int)Math.round((double)ingredient.relx / 18.0) - 3;
            int slotY = (int)Math.round((double)ingredient.rely / 20.0) - 2;
            if (slotY >= 3) {
                return false;
            }
            if (slotX == 3) {
                slotX = 2;
            }
            if ((slotIndex = slotX + slotY * 3) < 0 || slotIndex > 9) {
                return false;
            }
            this.packIngredient(recipe, slotIndex, ingredient, limited);
            return true;
        }

        private boolean addRegularCraftingItems(PositionedStack ingredient, NBTTagCompound recipe, boolean limited) throws IOException {
            int slotX = (ingredient.relx - 25) / 18;
            int slotY = (ingredient.rely - 6) / 18;
            int slotIndex = slotX + slotY * 3;
            this.packIngredient(recipe, slotIndex, ingredient, limited);
            return true;
        }

        protected boolean addIngredientToItems(PositionedStack ingredient, NBTTagCompound recipe, boolean limited) throws IOException {
            return this.isArcaneHandler ? this.addArcaneCraftingItems(ingredient, recipe, limited) : this.addRegularCraftingItems(ingredient, recipe, limited);
        }
    }
}

