/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;

public class TFGenThorns
extends TFGenerator {
    private static final int MAX_SPREAD = 7;
    private static final int CHANCE_OF_BRANCH = 3;
    private static final int CHANCE_OF_LEAF = 3;
    private static final int CHANCE_LEAF_IS_ROSE = 50;

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int nextLength = 2 + rand.nextInt(4);
        int maxLength = 2 + rand.nextInt(4) + rand.nextInt(4) + rand.nextInt(4);
        this.placeThorns(world, rand, x, y, z, nextLength, ForgeDirection.UP, maxLength, x, y, z);
        return true;
    }

    private void placeThorns(World world, Random rand, int x, int y, int z, int length, ForgeDirection dir, int maxLength, int ox, int oy, int oz) {
        int nextZ;
        int nextY;
        int nextX;
        int middle;
        boolean complete = false;
        for (int i = 0; i < length; ++i) {
            int dx = x + dir.offsetX * i;
            int dy = y + dir.offsetY * i;
            int dz = z + dir.offsetZ * i;
            if (Math.abs(dx - ox) >= 7 || Math.abs(dz - oz) >= 7 || !this.canPlaceThorns(world, dx, dy, dz)) break;
            this.setBlockAndMetadata(world, dx, dy, dz, TFBlocks.thorns, this.getMetaFor(dir));
            if (i != length - 1) continue;
            complete = true;
            if (rand.nextInt(3) != 0 || !world.func_147437_c(dx + dir.offsetX, dy + dir.offsetY, dz + dir.offsetZ)) continue;
            if (rand.nextInt(50) > 0) {
                this.setBlockAndMetadata(world, dx + dir.offsetX, dy + dir.offsetY, dz + dir.offsetZ, TFBlocks.leaves3, 0);
                continue;
            }
            this.setBlock(world, dx + dir.offsetX, dy + dir.offsetY, dz + dir.offsetZ, TFBlocks.thornRose);
        }
        if (complete && maxLength > 1) {
            ForgeDirection nextDir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
            int nextX2 = x + dir.offsetX * (length - 1) + nextDir.offsetX;
            int nextY2 = y + dir.offsetY * (length - 1) + nextDir.offsetY;
            int nextZ2 = z + dir.offsetZ * (length - 1) + nextDir.offsetZ;
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextX2, nextY2, nextZ2, nextLength, nextDir, maxLength - 1, ox, oy, oz);
        }
        if (complete && length > 3 && rand.nextInt(3) == 0) {
            middle = rand.nextInt(length);
            ForgeDirection nextDir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
            nextX = x + dir.offsetX * middle + nextDir.offsetX;
            nextY = y + dir.offsetY * middle + nextDir.offsetY;
            nextZ = z + dir.offsetZ * middle + nextDir.offsetZ;
            int nextLength = 1 + rand.nextInt(maxLength);
            this.placeThorns(world, rand, nextX, nextY, nextZ, nextLength, nextDir, maxLength - 1, ox, oy, oz);
        }
        if (complete && length > 3 && rand.nextInt(3) == 0) {
            middle = rand.nextInt(length);
            ForgeDirection nextDir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
            nextX = x + dir.offsetX * middle + nextDir.offsetX;
            nextY = y + dir.offsetY * middle + nextDir.offsetY;
            nextZ = z + dir.offsetZ * middle + nextDir.offsetZ;
            if (world.func_147437_c(nextX, nextY, nextZ)) {
                this.setBlockAndMetadata(world, nextX, nextY, nextZ, TFBlocks.leaves3, 0);
            }
        }
    }

    private boolean canPlaceThorns(World world, int dx, int dy, int dz) {
        return world.func_147437_c(dx, dy, dz) || world.func_147439_a(dx, dy, dz).isLeaves((IBlockAccess)world, dx, dy, dz);
    }

    private int getMetaFor(ForgeDirection dir) {
        switch (dir) {
            default: {
                return 0;
            }
            case EAST: 
            case WEST: {
                return 4;
            }
            case NORTH: 
            case SOUTH: 
        }
        return 8;
    }
}

