/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import glowredman.txloader.RemoteHandler;
import glowredman.txloader.TXLoaderCore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

class JarHandler {
    static final Map<String, Path> CACHED_CLIENT_JARS = new HashMap<String, Path>();
    static final Map<String, Path> CACHED_SERVER_JARS = new HashMap<String, Path>();
    static Path txloaderCache;

    JarHandler() {
    }

    static void indexJars() {
        String userHome = System.getProperty("user.home");
        txloaderCache = Paths.get(userHome, "txloader");
        ArrayList<Pair> clientLocations = new ArrayList<Pair>();
        clientLocations.add(Pair.of((Object)txloaderCache, (Object)"client.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, "AppData", "Roaming", ".minecraft", "versions"), (Object)"%s.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "forge_gradle", "minecraft_repo", "versions"), (Object)"client.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "minecraft", "net", "minecraft", "minecraft"), (Object)"minecraft-%s.jar"));
        clientLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "retro_futura_gradle", "mc-vanilla"), (Object)"client.jar"));
        ArrayList<Pair> serverLocations = new ArrayList<Pair>();
        clientLocations.add(Pair.of((Object)txloaderCache, (Object)"server.jar"));
        serverLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "forge_gradle", "minecraft_repo", "versions"), (Object)"server.jar"));
        serverLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "minecraft", "net", "minecraft", "minecraft_server"), (Object)"minecraft_server-%s.jar"));
        serverLocations.add(Pair.of((Object)Paths.get(userHome, ".gradle", "caches", "retro_futura_gradle", "mc-vanilla"), (Object)"server.jar"));
        block0: for (String version : RemoteHandler.VERSIONS.keySet()) {
            Path jarPath;
            for (Pair location : clientLocations) {
                jarPath = ((Path)location.getLeft()).resolve(version).resolve(String.format((String)location.getRight(), version));
                if (!Files.exists(jarPath, new LinkOption[0])) continue;
                CACHED_CLIENT_JARS.put(version, jarPath);
                TXLoaderCore.LOGGER.debug("Found CLIENT jar for version {} at {}", new Object[]{version, jarPath});
                break;
            }
            for (Pair location : serverLocations) {
                jarPath = ((Path)location.getLeft()).resolve(version).resolve(String.format((String)location.getRight(), version));
                if (!Files.exists(jarPath, new LinkOption[0])) continue;
                CACHED_SERVER_JARS.put(version, jarPath);
                TXLoaderCore.LOGGER.debug("Found SERVER jar for version {} at {}", new Object[]{version, jarPath});
                continue block0;
            }
        }
    }
}

