/*
 * Decompiled with CFR 0.152.
 */
package io.github.legacymoddingmc.unimixins.all;

import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import io.github.legacymoddingmc.unimixins.all.AllConfig;
import io.github.legacymoddingmc.unimixins.all.repackage.common.config.ConfigUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class AllCore
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"unimixins");
    private static List<Class<?>> embeddedCorePluginClasses = new ArrayList();
    private static List<IFMLLoadingPlugin> embeddedCorePluginInstances = new ArrayList<IFMLLoadingPlugin>();
    private static List<String> CONCERNING_JAR_PREFIXES = Arrays.asList("gtnhmixins-", "gasstation-", "mixinbooterlegacy-", "spongemixins-", "mixingasm-");
    private static final Pattern LETTER = Pattern.compile("[a-z]");

    private static void doSanityCheck() {
        ArrayList<String> concerningJars = new ArrayList<String>();
        for (URL url : Launch.classLoader.getSources()) {
            int firstLetterIndex;
            String[] components;
            String name;
            Matcher matcher;
            String path = url.getPath();
            if (!path.endsWith(".jar") || !(matcher = LETTER.matcher(name = (components = path.split("/"))[components.length - 1].toLowerCase())).find() || !AllCore.anyPrefixesMatch(name = name.substring(firstLetterIndex = matcher.start()), CONCERNING_JAR_PREFIXES)) continue;
            concerningJars.add(name);
        }
        if (!concerningJars.isEmpty()) {
            String theWarning = "Detected incompatible jars: " + concerningJars;
            LOGGER.warn("=======================================================================================");
            LOGGER.warn("WARNING / WARNING / WARNING / WARNING / WARNING / WARNING / WARNING / WARNING / WARNING");
            LOGGER.warn("=======================================================================================");
            LOGGER.error(theWarning);
            LOGGER.error("The game will almost certainly crash!");
            LOGGER.fatal("======================================================================================");
            throw new Error(theWarning);
        }
    }

    private static boolean anyPrefixesMatch(String s, Collection<String> prefixes) {
        for (String p : prefixes) {
            if (!s.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public AllCore() {
        LOGGER.info("Instantiating AllCore");
        for (Class<?> cls : embeddedCorePluginClasses) {
            try {
                embeddedCorePluginInstances.add((IFMLLoadingPlugin)cls.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String[] getASMTransformerClass() {
        ArrayList<String> classes = new ArrayList<String>();
        for (IFMLLoadingPlugin p : embeddedCorePluginInstances) {
            for (String s : p.getASMTransformerClass()) {
                classes.add(s);
            }
        }
        return classes.toArray(new String[0]);
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        for (IFMLLoadingPlugin p : embeddedCorePluginInstances) {
            p.injectData(data);
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        ConfigUtil.load(AllConfig.class);
        if (AllConfig.enableIntegrityChecks) {
            AllCore.doSanityCheck();
        } else {
            LOGGER.debug("Skipping sanity check because integrity checks are disabled in the config.");
        }
        try {
            for (String s : IOUtils.toString((URL)AllCore.class.getResource("/META-INF/unimixins-all.EmbeddedFMLCorePlugins.txt")).split(" ")) {
                Class<?> cls = Class.forName(s);
                embeddedCorePluginClasses.add(cls);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

