/*
 * Decompiled with CFR 0.152.
 */
package io.github.legacymoddingmc.unimixins.gasstation;

import io.github.legacymoddingmc.unimixins.gasstation.GasStationConfig;
import io.github.legacymoddingmc.unimixins.gasstation.repackage.common.config.ConfigUtil;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GasStationModule {
    private static final Logger LOGGER = LogManager.getLogger((String)"unimixin-gasstation");

    public static void init() {
        ConfigUtil.load(GasStationConfig.class);
        if (GasStationConfig.enableIntegrityChecks) {
            GasStationModule.checkComponentIntegrity();
        } else {
            LOGGER.debug("Skipping integrity checks because they are disabled in the config.");
        }
    }

    private static void checkComponentIntegrity() {
        ArrayList<String> missingComponents = new ArrayList<String>();
        if (!GasStationModule.classExists("com.falsepattern.gasstation.core.GasStationCore")) {
            missingComponents.add("GasStation");
        }
        if (!GasStationModule.classExists("makamys.mixingasm.api.TransformerInclusions")) {
            missingComponents.add("Mixingasm");
        }
        if (!GasStationModule.classExists("ru.timeconqueror.spongemixins.core.SpongeMixinsCore")) {
            missingComponents.add("SpongeMixins");
        }
        if (!GasStationModule.classExists("io.github.tox1cozz.mixinbooterlegacy.MixinBooterLegacyPlugin")) {
            missingComponents.add("MixinBooterLegacy");
        }
        if (!GasStationModule.classExists("org.spongepowered.asm.lib.Opcodes") || GasStationModule.classExists("org.spongepowered.libraries.org.objectweb.asm.Opcodes")) {
            missingComponents.add("MixinBooterLegacy");
        }
        if (!missingComponents.isEmpty()) {
            LOGGER.error("The following missing components were detected: " + missingComponents);
            LOGGER.error("Please obtain mods which provide them.");
            throw new RuntimeException("Missing components detected");
        }
    }

    public static boolean classExists(String string) {
        return GasStationModule.class.getResource("/" + string.replaceAll("\\.", "/") + ".class") != null;
    }
}

