/*
 * Decompiled with CFR 0.152.
 */
package zarkov.utilityworlds;

import appeng.api.AEApi;
import appeng.api.features.IWorldGen;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkHandshakeEstablished;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import zarkov.utilityworlds.UW_Log;
import zarkov.utilityworlds.UW_Messages;
import zarkov.utilityworlds.UW_PortalBlock;
import zarkov.utilityworlds.UW_PortalBlockGarden;
import zarkov.utilityworlds.UW_PortalBlockMining;
import zarkov.utilityworlds.UW_PortalBlockReturn;
import zarkov.utilityworlds.UW_PortalBlockVoid;
import zarkov.utilityworlds.UW_PortalTileEntity;
import zarkov.utilityworlds.UW_Utils;
import zarkov.utilityworlds.UW_WorldProviderGarden;
import zarkov.utilityworlds.UW_WorldProviderMining;
import zarkov.utilityworlds.UW_WorldProviderVoid;

@Mod(modid="utilityworlds", name="Utility Worlds", version="1.0.9d")
public class UtilityWorlds {
    @Mod.Instance(value="utilityworlds")
    public static UtilityWorlds instance;
    public static final UW_PortalBlockMining portalBlockMining;
    public static final UW_PortalBlockVoid portalBlockVoid;
    public static final UW_PortalBlockGarden portalBlockGarden;
    public static final UW_PortalBlockReturn portalBlockReturn;
    public static final HashMap<Integer, Integer> dimensionMap;
    public static SimpleNetworkWrapper channel;
    public static boolean allowPortalCrafting;
    public static boolean allowGardenWorld;
    public static boolean preventAe2Meteors;
    public static double starfieldBrightness;
    public static int dimensionIDOffset;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        UW_Log.trace("Registering network channel and messages.");
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("UW_CHANNEL");
        channel.registerMessage(UW_Messages.MsgTeleportHandler.class, UW_Messages.MsgTeleport.class, 0, Side.CLIENT);
        channel.registerMessage(UW_Messages.MsgTeleportHandler.class, UW_Messages.MsgTeleport.class, 1, Side.SERVER);
        channel.registerMessage(UW_Messages.MsgDimensionListHandler.class, UW_Messages.MsgDimensionList.class, 2, Side.CLIENT);
        channel.registerMessage(UW_Messages.MsgDimensionListHandler.class, UW_Messages.MsgDimensionList.class, 3, Side.SERVER);
        channel.registerMessage(UW_Messages.MsgLinkDimensionHandler.class, UW_Messages.MsgLinkDimension.class, 4, Side.CLIENT);
        channel.registerMessage(UW_Messages.MsgLinkDimensionHandler.class, UW_Messages.MsgLinkDimension.class, 5, Side.SERVER);
        NetworkRegistry.INSTANCE.newEventDrivenChannel("UW_EVENTCHANNEL").register((Object)this);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        allowPortalCrafting = config.get("general", "AllowPortalCrafting", true, "Determines if Portals can be crafted.").getBoolean(true);
        allowGardenWorld = config.get("general", "AllowGardenWorld", true, "Determines if Garden World portals can be crafted.").getBoolean(true);
        preventAe2Meteors = config.get("general", "PreventAe2Meteors", true, "If true, Applied Energistics 2 meteors will not be generated in the created dimensions.").getBoolean(true);
        starfieldBrightness = config.get("general", "StarfieldBrightness", 0.0, "Sets how bright the stars are, from 0.0 (totally black) to 1.0.").getDouble(0.0);
        dimensionIDOffset = config.get("general", "DimensionIDOffset", dimensionIDOffset, "Set the offset where the UW Dimensions will start to look for free DimIDs. This does NOT affect existing UW Dimensions.").getInt();
        if (starfieldBrightness < 0.0) {
            starfieldBrightness = 0.0;
        }
        if (starfieldBrightness > 1.0) {
            starfieldBrightness = 1.0;
        }
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        UW_Log.trace("Registering callback with Waila.");
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"zarkov.utilityworlds.UW_WailaHandler.callback");
        if (Loader.isModLoaded((String)"appliedenergistics2-core") && preventAe2Meteors) {
            UW_Log.info("Applied Energistics 2 is present. Calling API to disable meteor generation in mining worlds.");
            try {
                IWorldGen.WorldGenType type = null;
                try {
                    type = IWorldGen.WorldGenType.valueOf((String)"Metorites");
                }
                catch (IllegalArgumentException e) {
                    type = IWorldGen.WorldGenType.valueOf((String)"Meteorites");
                }
                if (null != type) {
                    AEApi.instance().registries().worldgen().disableWorldGenForProviderID(type, UW_WorldProviderMining.class);
                    AEApi.instance().registries().worldgen().disableWorldGenForProviderID(type, UW_WorldProviderVoid.class);
                    AEApi.instance().registries().worldgen().disableWorldGenForProviderID(type, UW_WorldProviderGarden.class);
                } else {
                    UW_Log.warn("Failed to invoke AE2 API.");
                }
            }
            catch (Throwable outer) {
                UW_Log.warn("Exception while calling AE2 API", outer);
            }
        }
    }

    @SubscribeEvent
    public void onHandshakeEstablished(FMLNetworkEvent.CustomNetworkEvent event) {
        if (event.wrappedEvent instanceof NetworkHandshakeEstablished) {
            NetworkHandshakeEstablished handshake = (NetworkHandshakeEstablished)event.wrappedEvent;
            if (handshake.netHandler instanceof NetHandlerPlayServer) {
                NetHandlerPlayServer handler = (NetHandlerPlayServer)handshake.netHandler;
                UW_Messages.MsgDimensionList message = new UW_Messages.MsgDimensionList();
                UW_Log.debug("Sending UW dimension list to connecting player '" + handler.field_147369_b.getDisplayName() + "'.");
                handler.func_147359_a(channel.getPacketFrom((IMessage)message));
            }
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        UW_Log.trace("Registering blocks and tile entity.");
        GameRegistry.registerBlock((Block)portalBlockMining, (String)"uw_portal_mining");
        GameRegistry.registerBlock((Block)portalBlockVoid, (String)"uw_portal_void");
        GameRegistry.registerBlock((Block)portalBlockGarden, (String)"uw_portal_garden");
        GameRegistry.registerBlock((Block)portalBlockReturn, (String)"uw_portal_return");
        GameRegistry.registerTileEntity(UW_PortalTileEntity.class, (String)"uw_portal_te");
        portalBlockMining.func_149647_a(CreativeTabs.field_78030_b);
        portalBlockVoid.func_149647_a(CreativeTabs.field_78030_b);
        portalBlockGarden.func_149647_a(CreativeTabs.field_78030_b);
        portalBlockReturn.func_149647_a(CreativeTabs.field_78030_b);
        if (allowPortalCrafting) {
            UW_Log.trace("Registering block recipes.");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)portalBlockMining), (Object[])new Object[]{"dpd", "ebe", "ooo", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('p'), Items.field_151046_w, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('o'), Blocks.field_150343_Z});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)portalBlockVoid), (Object[])new Object[]{"ded", "ebe", "ooo", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('o'), Blocks.field_150343_Z});
            if (allowGardenWorld) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)portalBlockGarden), (Object[])new Object[]{"dsd", "tbu", "ooo", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('s'), new ItemStack(Blocks.field_150345_g, 1, 0), Character.valueOf('t'), new ItemStack(Blocks.field_150345_g, 1, 1), Character.valueOf('u'), new ItemStack(Blocks.field_150345_g, 1, 2), Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('o'), Blocks.field_150343_Z});
            }
        }
        if (event.getSide() == Side.CLIENT && !this.initializeDimensions()) {
            UW_Log.error("Failed to initialize dimensions.");
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        UW_Log.trace("Server starting.");
        if (!this.initializeDimensions()) {
            UW_Log.error("Failed to initialize UW dimensions.");
        }
    }

    protected static int getNextDimensionID() {
        int tRetVal = 0;
        int tCurrIDX = dimensionIDOffset;
        while (tRetVal == 0) {
            if (!dimensionMap.containsKey(tCurrIDX) && !DimensionManager.isDimensionRegistered((int)tCurrIDX)) {
                tRetVal = tCurrIDX;
                continue;
            }
            tCurrIDX += dimensionIDOffset < 0 ? -1 : 1;
        }
        return tRetVal;
    }

    private boolean initializeDimensions() {
        boolean retval = true;
        dimensionMap.clear();
        try {
            File root = DimensionManager.getCurrentSaveRootDirectory();
            if (null != root) {
                int registered = 0;
                UW_Log.debug("Searching for UW dimensions.");
                for (File file : root.listFiles()) {
                    String name = file.getName();
                    if (!file.isDirectory() || !name.startsWith("UW_MINING_") && !name.startsWith("UW_VOID_") && !name.startsWith("UW_GARDEN_")) continue;
                    try {
                        int dimensionId = Integer.parseInt(name.split("_")[2]);
                        UW_PortalBlock.PORTAL_TYPE type = UW_PortalBlock.PORTAL_TYPE.MINING;
                        if (name.startsWith("UW_VOID_")) {
                            type = UW_PortalBlock.PORTAL_TYPE.VOID;
                        } else if (name.startsWith("UW_GARDEN_")) {
                            type = UW_PortalBlock.PORTAL_TYPE.GARDEN;
                        }
                        ++registered;
                        dimensionMap.put(dimensionId, type.value());
                        UW_Log.trace("Registering UW dimension and world provider with id " + dimensionId + ".");
                        DimensionManager.registerProviderType((int)dimensionId, UW_Utils.getWorldProvider(type), (boolean)false);
                        if (!DimensionManager.isDimensionRegistered((int)dimensionId)) {
                            DimensionManager.registerDimension((int)dimensionId, (int)dimensionId);
                            DimensionManager.initDimension((int)dimensionId);
                        }
                        if (UW_PortalBlock.PORTAL_TYPE.MINING != type || !Loader.isModLoaded((String)"appliedenergistics2-core") || preventAe2Meteors) continue;
                        UW_Utils.enableAe2MeteorsForDimension(dimensionId);
                    }
                    catch (Exception e) {
                        retval = false;
                        UW_Log.error("Failed to register dimension or provider.", e);
                    }
                }
                UW_Log.debug("Found and registered " + registered + " UW dimension(s).");
            }
        }
        catch (Exception e2) {
            UW_Log.error("Exception while registering providers.", e2);
        }
        return retval;
    }

    static {
        portalBlockMining = new UW_PortalBlockMining();
        portalBlockVoid = new UW_PortalBlockVoid();
        portalBlockGarden = new UW_PortalBlockGarden();
        portalBlockReturn = new UW_PortalBlockReturn();
        dimensionMap = new HashMap();
        allowPortalCrafting = true;
        allowGardenWorld = true;
        preventAe2Meteors = true;
    }
}

