/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.integration.model.buttons.DirtyChunkButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import com.sinthoras.visualprospecting.integration.model.locations.DirtyChunkLocation;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;

public class DirtyChunkLayerManager
extends LayerManager {
    public static final DirtyChunkLayerManager instance = new DirtyChunkLayerManager();

    public DirtyChunkLayerManager() {
        super(DirtyChunkButtonManager.instance);
    }

    @Override
    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return true;
    }

    @Override
    protected List<? extends ILocationProvider> generateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int minX = Utils.coordBlockToChunk(minBlockX);
        int minZ = Utils.coordBlockToChunk(minBlockZ);
        int maxX = Utils.coordBlockToChunk(maxBlockX);
        int maxZ = Utils.coordBlockToChunk(maxBlockZ);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        int playerDimensionId = player.field_71093_bK;
        ArrayList<DirtyChunkLocation> dirtyChunks = new ArrayList<DirtyChunkLocation>();
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71218_a(playerDimensionId) == null) {
            return dirtyChunks;
        }
        WorldServer w = MinecraftServer.func_71276_C().func_71218_a(playerDimensionId);
        IChunkProvider chunkProvider = w.func_72863_F();
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                if (!chunkProvider.func_73149_a(chunkX, chunkZ)) continue;
                boolean dirty = w.func_72964_e((int)chunkX, (int)chunkZ).field_76643_l;
                dirtyChunks.add(new DirtyChunkLocation(chunkX, chunkZ, playerDimensionId, dirty));
            }
        }
        return dirtyChunks;
    }
}

