/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.gtnewhorizons.navigator.api.journeymap.waypoints.JMWaypointManager;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalInteractableRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.WaypointManager;
import com.gtnewhorizons.navigator.api.xaero.waypoints.XaeroWaypointManager;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import com.sinthoras.visualprospecting.integration.model.buttons.OreVeinButtonManager;
import com.sinthoras.visualprospecting.integration.model.locations.OreVeinLocation;
import com.sinthoras.visualprospecting.integration.model.render.OreVeinRenderStep;
import org.jetbrains.annotations.Nullable;

public class OreVeinLayerManager
extends InteractableLayerManager {
    public static final OreVeinLayerManager instance = new OreVeinLayerManager();

    public OreVeinLayerManager() {
        super((ButtonManager)OreVeinButtonManager.instance);
    }

    public void onOpenMap() {
        VeinTypeCaching.recalculateNEISearch();
    }

    @Nullable
    protected LayerRenderer addLayerRenderer(InteractableLayerManager manager, SupportedMods mod) {
        return new UniversalInteractableRenderer(manager).withRenderStep(location -> new OreVeinRenderStep((OreVeinLocation)location));
    }

    @Nullable
    protected WaypointManager addWaypointManager(InteractableLayerManager manager, SupportedMods mod) {
        JMWaypointManager jMWaypointManager;
        switch (mod) {
            case JourneyMap: {
                jMWaypointManager = new JMWaypointManager(manager);
                break;
            }
            case XaeroWorldMap: {
                jMWaypointManager = new XaeroWaypointManager(manager, "!");
                break;
            }
            default: {
                jMWaypointManager = null;
            }
        }
        return jMWaypointManager;
    }

    protected ILocationProvider generateLocation(int chunkX, int chunkZ, int dim) {
        int oreChunkX = Utils.mapToCenterOreChunkCoord(chunkX);
        int oreChunkZ = Utils.mapToCenterOreChunkCoord(chunkZ);
        if (chunkX % oreChunkX != 0 || chunkZ % oreChunkZ != 0) {
            return null;
        }
        OreVeinPosition oreVeinPosition = ClientCache.instance.getOreVein(dim, oreChunkX, oreChunkZ);
        if (oreVeinPosition.veinType != VeinType.NO_VEIN) {
            return new OreVeinLocation(oreVeinPosition);
        }
        return null;
    }
}

