/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.render;

import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.UniversalRenderStep;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidChunkLocation;

public class UndergroundFluidChunkRenderStep
extends UniversalRenderStep<UndergroundFluidChunkLocation> {
    public UndergroundFluidChunkRenderStep(UndergroundFluidChunkLocation location) {
        super((ILocationProvider)location);
        this.setFontScale(0.3f);
    }

    public void draw(double topX, double topY, float drawScale, double zoom) {
        if (((UndergroundFluidChunkLocation)this.location).getFluidAmount() > 0 && this.getZoomStep() >= (double)Config.minZoomLevelForUndergroundFluidDetails) {
            float alpha = (float)(((UndergroundFluidChunkLocation)this.location).getFluidAmount() - ((UndergroundFluidChunkLocation)this.location).getMinAmountInField()) / (float)(((UndergroundFluidChunkLocation)this.location).getMaxAmountInField() - ((UndergroundFluidChunkLocation)this.location).getMinAmountInField() + 1);
            int fluidColor = ((UndergroundFluidChunkLocation)this.location).getFluid().getColor();
            DrawUtils.drawRect((double)topX, (double)topY, (double)this.getAdjustedWidth(), (double)this.getAdjustedHeight(), (int)fluidColor, (int)((int)(alpha *= 255.0f)));
            if (((UndergroundFluidChunkLocation)this.location).getFluidAmount() >= ((UndergroundFluidChunkLocation)this.location).getMaxAmountInField()) {
                DrawUtils.drawHollowRect((double)topX, (double)topY, (double)this.getAdjustedWidth(), (double)this.getAdjustedHeight(), (int)16766720, (int)204, (double)1.5);
            }
            DrawUtils.drawLabel((String)((UndergroundFluidChunkLocation)this.getLocation()).getFluidAmountFormatted(), (double)(topX + this.getAdjustedWidth() / 2.0), (double)(topY + this.getAdjustedHeight() / 2.0), (int)-1, (int)-1275068416, (boolean)true, (double)this.getFontScale());
        }
    }
}

