/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.mixinplugin;

import com.sinthoras.visualprospecting.mixinplugin.TargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public enum Mixins {
    WorldGenContainerMixin("bartworks.WorldGenContainerMixin", TargetedMod.BARTWORKS),
    GT_Worldgenerator_SpaceMixin("galacticgreg.GT_Worldgenerator_SpaceMixin", TargetedMod.GALACTICGREG),
    GT_Block_Ores_AbstractMixin("gregtech.GT_Block_Ores_AbstractMixin", TargetedMod.GT5U),
    GT_MetaTileEntity_AdvSeismicProspectorMixin("gregtech.GT_MetaTileEntity_AdvSeismicProspectorMixin", TargetedMod.GT5U),
    GT_MetaTileEntity_ScannerMixin("gregtech.GT_MetaTileEntity_ScannerMixin", TargetedMod.GT5U),
    GT_WorldGenContainerMixin("gregtech.WorldGenContainerMixin", TargetedMod.GT5U),
    MinecraftServerAccessorMixin("minecraft.MinecraftServerAccessor", Phase.EARLY, Side.BOTH, TargetedMod.VANILLA),
    ItemEditableBookMixin("minecraft.ItemEditableBookMixin", Phase.EARLY, TargetedMod.VANILLA);

    public final String mixinClass;
    public final Phase phase;
    private final Side side;
    private final List<TargetedMod> targetedMods;

    private Mixins(String mixinClass, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = Phase.LATE;
        this.side = Side.BOTH;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    private Mixins(String mixinClass, Phase phase, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = phase;
        this.side = Side.BOTH;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    private Mixins(String mixinClass, Side side, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = Phase.LATE;
        this.side = side;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    private Mixins(String mixinClass, Phase phase, Side side, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.phase = phase;
        this.side = side;
        this.targetedMods = Arrays.asList(targetedMods);
    }

    public boolean shouldLoad(Set<String> loadedCoreMods, Set<String> loadedMods) {
        return this.shouldLoadSide() && this.allModsLoaded(this.targetedMods, loadedCoreMods, loadedMods);
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    private boolean allModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return false;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && !loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    public static enum Phase {
        EARLY,
        LATE;

    }

    static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

