/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class DimensionCache {
    private static final File oldIdFile = new File("visualprospecting/", "veintypesLUT");
    private static Short2ObjectMap<String> idConversionMap;
    private final Long2ObjectMap<OreVeinPosition> oreChunks = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<UndergroundFluidPosition> undergroundFluids = new Long2ObjectOpenHashMap();
    public final int dimensionId;
    private boolean isDirty = false;
    private boolean preventSaving = false;

    public DimensionCache(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public NBTTagCompound saveToNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("ores", (NBTBase)this.saveOres());
        compound.func_74782_a("fluids", (NBTBase)this.saveFluids());
        compound.func_74768_a("dim", this.dimensionId);
        this.isDirty = false;
        return compound;
    }

    private NBTTagCompound saveOres() {
        NBTTagCompound compound = new NBTTagCompound();
        for (OreVeinPosition vein : this.oreChunks.values()) {
            NBTTagCompound veinCompound = new NBTTagCompound();
            veinCompound.func_74768_a("chunkX", vein.chunkX);
            veinCompound.func_74768_a("chunkZ", vein.chunkZ);
            veinCompound.func_74778_a("veinTypeName", vein.veinType.name);
            veinCompound.func_74757_a("depleted", vein.isDepleted());
            compound.func_74782_a(String.valueOf(this.getOreVeinKey(vein.chunkX, vein.chunkZ)), (NBTBase)veinCompound);
        }
        return compound;
    }

    private NBTTagCompound saveFluids() {
        NBTTagCompound compound = new NBTTagCompound();
        for (UndergroundFluidPosition fluid : this.undergroundFluids.values()) {
            NBTTagCompound fluidCompound = new NBTTagCompound();
            fluidCompound.func_74768_a("chunkX", fluid.chunkX);
            fluidCompound.func_74768_a("chunkZ", fluid.chunkZ);
            fluidCompound.func_74778_a("fluidName", fluid.fluid.getName());
            NBTTagList chunkList = new NBTTagList();
            for (int i = 0; i < 8; ++i) {
                chunkList.func_74742_a((NBTBase)new NBTTagIntArray(fluid.chunks[i]));
            }
            fluidCompound.func_74782_a("chunks", (NBTBase)chunkList);
            compound.func_74782_a(String.valueOf(this.getUndergroundFluid(fluid.chunkX, fluid.chunkZ)), (NBTBase)fluidCompound);
        }
        return compound;
    }

    public void loadFromNbt(NBTTagCompound compound) {
        NBTTagCompound ores = compound.func_74775_l("ores");
        for (NBTBase base : ores.field_74784_a.values()) {
            VeinType veinType;
            NBTTagCompound veinCompound = (NBTTagCompound)base;
            int chunkX = veinCompound.func_74762_e("chunkX");
            int chunkZ = veinCompound.func_74762_e("chunkZ");
            boolean depleted = veinCompound.func_74767_n("depleted");
            if (veinCompound.func_74764_b("veinTypeId")) {
                veinType = this.getVeinFromId(veinCompound.func_74765_d("veinTypeId"));
                if (veinType == null) {
                    return;
                }
                this.markDirty();
            } else {
                veinType = VeinTypeCaching.getVeinType(veinCompound.func_74779_i("veinTypeName"));
            }
            this.oreChunks.put(this.getOreVeinKey(chunkX, chunkZ), (Object)new OreVeinPosition(this.dimensionId, chunkX, chunkZ, veinType, depleted));
        }
        NBTTagCompound fluids = compound.func_74775_l("fluids");
        for (NBTBase base : fluids.field_74784_a.values()) {
            NBTTagCompound fluidCompound = (NBTTagCompound)base;
            int chunkX = fluidCompound.func_74762_e("chunkX");
            int chunkZ = fluidCompound.func_74762_e("chunkZ");
            String fluidName = fluidCompound.func_74779_i("fluidName");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            int[][] chunks = new int[8][8];
            NBTTagList chunkList = fluidCompound.func_150295_c("chunks", 11);
            for (int i = 0; i < 8; ++i) {
                chunks[i] = chunkList.func_150306_c(i);
            }
            this.undergroundFluids.put(this.getUndergroundFluidKey(chunkX, chunkZ), (Object)new UndergroundFluidPosition(this.dimensionId, chunkX, chunkZ, fluid, chunks));
        }
    }

    void loadLegacy(ByteBuffer oreChunksBuffer, ByteBuffer undergroundFluidsBuffer) {
        int chunkZ;
        int chunkX;
        if (oreChunksBuffer != null) {
            while (oreChunksBuffer.remaining() >= 10) {
                chunkX = oreChunksBuffer.getInt();
                chunkZ = oreChunksBuffer.getInt();
                short veinTypeId = oreChunksBuffer.getShort();
                boolean depleted = (veinTypeId & 0x8000) > 0;
                VeinType veinType = this.getVeinFromId((short)(veinTypeId & Short.MAX_VALUE));
                if (veinType == null) {
                    return;
                }
                this.oreChunks.put(this.getOreVeinKey(chunkX, chunkZ), (Object)new OreVeinPosition(this.dimensionId, chunkX, chunkZ, veinType, depleted));
            }
        }
        if (undergroundFluidsBuffer != null) {
            while (undergroundFluidsBuffer.remaining() >= 268) {
                Fluid fluid;
                chunkX = undergroundFluidsBuffer.getInt();
                chunkZ = undergroundFluidsBuffer.getInt();
                int fluidIDorNameLength = undergroundFluidsBuffer.getInt();
                if (fluidIDorNameLength < 0) {
                    byte[] fluidNameBytes = new byte[-fluidIDorNameLength];
                    undergroundFluidsBuffer.get(fluidNameBytes);
                    String fluidName = new String(fluidNameBytes, StandardCharsets.UTF_8);
                    fluid = FluidRegistry.getFluid((String)fluidName);
                } else {
                    fluid = FluidRegistry.getFluid((int)fluidIDorNameLength);
                }
                int[][] chunks = new int[8][8];
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        chunks[offsetChunkX][offsetChunkZ] = undergroundFluidsBuffer.getInt();
                    }
                }
                if (fluid == null) continue;
                this.undergroundFluids.put(this.getUndergroundFluidKey(chunkX, chunkZ), (Object)new UndergroundFluidPosition(this.dimensionId, chunkX, chunkZ, fluid, chunks));
            }
        }
    }

    private long getOreVeinKey(int chunkX, int chunkZ) {
        return Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(chunkX), Utils.mapToCenterOreChunkCoord(chunkZ));
    }

    private long getUndergroundFluidKey(int chunkX, int chunkZ) {
        return Utils.chunkCoordsToKey(Utils.mapToCornerUndergroundFluidChunkCoord(chunkX), Utils.mapToCornerUndergroundFluidChunkCoord(chunkZ));
    }

    public void toggleOreVein(int chunkX, int chunkZ) {
        long key = this.getOreVeinKey(chunkX, chunkZ);
        OreVeinPosition oreVeinPosition = (OreVeinPosition)this.oreChunks.get(key);
        if (oreVeinPosition != null) {
            oreVeinPosition.toggleDepleted();
            this.markDirty();
        }
    }

    public UpdateResult putOreVein(OreVeinPosition oreVeinPosition) {
        long key = this.getOreVeinKey(oreVeinPosition.chunkX, oreVeinPosition.chunkZ);
        OreVeinPosition storedOreVeinPosition = (OreVeinPosition)this.oreChunks.get(key);
        if (storedOreVeinPosition == null) {
            this.oreChunks.put(key, (Object)oreVeinPosition);
            this.markDirty();
            return UpdateResult.New;
        }
        if (storedOreVeinPosition.veinType != oreVeinPosition.veinType) {
            this.oreChunks.put(key, (Object)oreVeinPosition.joinDepletedState(storedOreVeinPosition));
            this.markDirty();
            return UpdateResult.New;
        }
        return UpdateResult.AlreadyKnown;
    }

    public UpdateResult putUndergroundFluid(UndergroundFluidPosition undergroundFluid) {
        long key = this.getUndergroundFluidKey(undergroundFluid.chunkX, undergroundFluid.chunkZ);
        UndergroundFluidPosition storedUndergroundFluid = (UndergroundFluidPosition)this.undergroundFluids.get(key);
        if (storedUndergroundFluid == null) {
            this.undergroundFluids.put(key, (Object)undergroundFluid);
            this.markDirty();
            return UpdateResult.New;
        }
        if (!storedUndergroundFluid.equals(undergroundFluid)) {
            this.undergroundFluids.put(key, (Object)undergroundFluid);
            this.markDirty();
            return UpdateResult.Updated;
        }
        return UpdateResult.AlreadyKnown;
    }

    public OreVeinPosition getOreVein(int chunkX, int chunkZ) {
        long key = this.getOreVeinKey(chunkX, chunkZ);
        return (OreVeinPosition)this.oreChunks.getOrDefault(key, (Object)OreVeinPosition.EMPTY_VEIN);
    }

    public UndergroundFluidPosition getUndergroundFluid(int chunkX, int chunkZ) {
        long key = this.getUndergroundFluidKey(chunkX, chunkZ);
        return (UndergroundFluidPosition)this.undergroundFluids.getOrDefault(key, (Object)UndergroundFluidPosition.NOT_PROSPECTED);
    }

    public Collection<OreVeinPosition> getAllOreVeins() {
        return this.oreChunks.values();
    }

    public Collection<UndergroundFluidPosition> getAllUndergroundFluids() {
        return this.undergroundFluids.values();
    }

    public boolean isDirty() {
        return this.isDirty && !this.preventSaving;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void clearOreVeins(int startChunkX, int startChunkZ, int endChunkX, int endChunkZ) {
        this.oreChunks.long2ObjectEntrySet().removeIf(entry -> {
            OreVeinPosition val = (OreVeinPosition)entry.getValue();
            boolean withinX = val.chunkX >= startChunkX && val.chunkX <= endChunkX;
            boolean withinZ = val.chunkZ >= startChunkZ && val.chunkZ <= endChunkZ;
            return withinX && withinZ;
        });
    }

    @Nullable
    private VeinType getVeinFromId(short veinTypeId) {
        String veinTypeName = (String)DimensionCache.getIdConversionMap().get(veinTypeId);
        if (veinTypeName == null) {
            this.preventSaving = true;
            VP.LOG.warn("Not loading ores in dimension {}. Couldn't find vein type for id {}, file {} may be missing.", new Object[]{this.dimensionId, veinTypeId, oldIdFile.getAbsolutePath()});
            return null;
        }
        return VeinTypeCaching.getVeinType(veinTypeName);
    }

    private static Short2ObjectMap<String> getIdConversionMap() {
        if (idConversionMap != null) {
            return idConversionMap;
        }
        if (!oldIdFile.exists()) {
            return Short2ObjectMaps.emptyMap();
        }
        try {
            Gson gson = new Gson();
            BufferedReader reader = Files.newBufferedReader(oldIdFile.toPath());
            Map map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Short>>(){}.getType());
            ((Reader)reader).close();
            Short2ObjectOpenHashMap result = new Short2ObjectOpenHashMap();
            result.put((short)0, (Object)"ore.mix.none");
            for (Map.Entry entry : map.entrySet()) {
                result.put(((Short)entry.getValue()).shortValue(), (Object)((String)entry.getKey()));
            }
            idConversionMap = result;
            return idConversionMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Short2ObjectMaps.emptyMap();
        }
    }

    public static enum UpdateResult {
        AlreadyKnown,
        Updated,
        New;

    }
}

