/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.veintypes;

import bartworks.system.material.Werkstoff;
import com.google.common.collect.ImmutableList;
import com.sinthoras.visualprospecting.database.veintypes.IOreMaterialProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.ArrayList;

public class BartworksOreMaterialProvider
implements IOreMaterialProvider {
    private final Werkstoff material;
    private final int primaryOreColor;
    private final String primaryOreName;
    private IIconContainer oreIconContainer;
    private ImmutableList<String> containedOres;

    public BartworksOreMaterialProvider(Werkstoff material) {
        this.material = material;
        short[] rgba = material.getRGBA();
        this.primaryOreColor = (rgba[0] & 0xFF) << 16 | (rgba[1] & 0xFF) << 8 | rgba[2] & 0xFF;
        this.primaryOreName = material.getLocalizedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconContainer getIconContainer() {
        if (this.oreIconContainer == null) {
            this.oreIconContainer = this.material.getTexSet().mTextures[OrePrefixes.ore.mTextureIndex];
        }
        return this.oreIconContainer;
    }

    @Override
    public int getColor() {
        return this.primaryOreColor;
    }

    @Override
    public String getLocalizedName() {
        return this.primaryOreName;
    }

    @Override
    public ImmutableList<String> getContainedOres(ShortCollection ores) {
        if (this.containedOres == null) {
            ArrayList<String> oreNames = new ArrayList<String>();
            ShortIterator shortIterator = ores.iterator();
            while (shortIterator.hasNext()) {
                short meta = (Short)shortIterator.next();
                Werkstoff werkstoff = (Werkstoff)Werkstoff.werkstoffHashMap.get(meta);
                if (werkstoff == null) {
                    oreNames.add(GregTechAPI.sGeneratedMaterials[meta].mLocalizedName);
                    continue;
                }
                oreNames.add(werkstoff.getLocalizedName());
            }
            this.containedOres = ImmutableList.copyOf(oreNames);
        }
        return this.containedOres;
    }
}

