/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    public static final int uploadPacketsPerSecond = 10;
    public static boolean enableProspecting = true;
    public static int cacheGenerationLogUpdateMinTime = 5;
    public static boolean recacheVeins = false;
    public static int minDelayBetweenVeinRequests = 2000;
    public static int minZoomLevelForOreLabel = 1;
    public static int minZoomLevelForUndergroundFluidDetails = 2;
    public static double uploadBandwidthBytes = 2000000.0;
    public static int uploadSizePerPacket = (int)(uploadBandwidthBytes / 10.0);
    public static int maxTransferCacheSizeMB = 50;

    public static void syncronizeConfiguration(File configFile) {
        Configuration configuration = new Configuration(configFile);
        configuration.load();
        Property enableProspectingProperty = configuration.get("general", "enableProspecting", true, "[CLIENT] You may want to disable prospecting for low-performance clients.");
        enableProspecting = enableProspectingProperty.getBoolean();
        Property cacheGenerationLogUpdateMinTimeProperty = configuration.get("general", "cacheGenerationLogUpdateMinTime", 5, "[SERVER] Minimum between log updates to show progress when caching save files. This happens only ONCE!");
        cacheGenerationLogUpdateMinTime = cacheGenerationLogUpdateMinTimeProperty.getInt();
        Property minDelayBetweenVeinRequestsProperty = configuration.get("network", "minDelayBetweenVeinRequests", 2000, "[CLIENT + SERVER] Anti spam mechanic: What is the minimum delay (in milliseconds) a player is allowed to request ore vein information.");
        minDelayBetweenVeinRequests = minDelayBetweenVeinRequestsProperty.getInt();
        Property minZoomLevelProperty = configuration.get("general", "minZoomLevelForOreLabel", 1, "[CLIENT] Minimum zoom level at which ore veins labels are displayed. Zoom starts at 0 and increments linearly.");
        minZoomLevelForOreLabel = minZoomLevelProperty.getInt();
        Property minZoomLevelForUndergroundFluidDetailsProperty = configuration.get("general", "minZoomLevelForUndergroundFluidDetails", 2, "[CLIENT] Minimum zoom level at which underground fluid details are displayed. Zoom starts at 0 and increments linearly.");
        minZoomLevelForUndergroundFluidDetails = minZoomLevelForUndergroundFluidDetailsProperty.getInt();
        Property uploadBandwidthProperty = configuration.get("network", "uploadBandwidth", 2000000, "[CLIENT + SERVER] Limit the bandwidth (in B/s) a client is allowed to transmit when uploading its prospection data. If exceeded, the client will be kicked!");
        uploadBandwidthBytes = uploadBandwidthProperty.getDouble();
        uploadSizePerPacket = (int)(uploadBandwidthBytes / 10.0);
        Property maxTransferCacheSizeMBProperty = configuration.get("general", "maxTransferCacheSizeMB", 50, "[Server] Limit the RAM size in MB of what can players use to synchronize their map data.");
        maxTransferCacheSizeMB = maxTransferCacheSizeMBProperty.getInt();
        Property recacheVeinsProperty = configuration.get("general", "recacheVeins", false, "[SERVER] Redo GT ore vein caching if set to True. Will automatically be set back to False the next time the game is started.");
        recacheVeins = recacheVeinsProperty.getBoolean();
        if (recacheVeins) {
            recacheVeinsProperty.set(false);
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    private static class Categories {
        public static final String general = "general";
        public static final String network = "network";

        private Categories() {
        }
    }

    private static class Defaults {
        public static final boolean enableProspecting = true;
        public static final int cacheGenerationLogUpdateMinTime = 5;
        public static final boolean recacheVeins = false;
        public static final int minDelayBetweenVeinRequests = 2000;
        public static final int minZoomLevelForOreLabel = 1;
        public static final int minZoomLevelForUndergroundFluidDetails = 2;
        public static final int uploadBandwidthBytes = 2000000;
        public static final int maxTransferCacheSizeMB = 50;

        private Defaults() {
        }
    }
}

