/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sinthoras.visualprospecting.VPMod;
import com.sinthoras.visualprospecting.hooks.HooksClient;
import cpw.mods.fml.common.Loader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;

public class Utils {
    public static boolean isDevelopmentEnvironment() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static boolean isBartworksInstalled() {
        return Loader.isModLoaded((String)"bartworks");
    }

    public static boolean isNEIInstalled() {
        return Loader.isModLoaded((String)"NotEnoughItems");
    }

    public static boolean isTCNodeTrackerInstalled() {
        return Loader.isModLoaded((String)"tcnodetracker");
    }

    public static boolean isJourneyMapInstalled() {
        return Loader.isModLoaded((String)"journeymap");
    }

    public static boolean isXaerosWorldMapInstalled() {
        return Loader.isModLoaded((String)"XaeroWorldMap");
    }

    public static int coordBlockToChunk(int blockCoord) {
        return blockCoord < 0 ? -(-blockCoord - 1 >> 4) - 1 : blockCoord >> 4;
    }

    public static int coordChunkToBlock(int chunkCoord) {
        return chunkCoord < 0 ? -(-chunkCoord << 4) : chunkCoord << 4;
    }

    public static long chunkCoordsToKey(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    public static int mapToCenterOreChunkCoord(int chunkCoord) {
        if (chunkCoord >= 0) {
            return chunkCoord - chunkCoord % 3 + 1;
        }
        return chunkCoord - chunkCoord % 3 - 1;
    }

    public static int mapToCornerUndergroundFluidChunkCoord(int chunkCoord) {
        return chunkCoord & 0xFFFFFFF8;
    }

    public static double journeyMapScaleToLinear(int jzoom) {
        return Math.pow(2.0, jzoom);
    }

    public static boolean isSmallOreId(short metaData) {
        return metaData >= 16000;
    }

    public static short oreIdToMaterialId(short metaData) {
        return (short)(metaData % 1000);
    }

    public static boolean isLogicalClient() {
        return VPMod.proxy instanceof HooksClient;
    }

    public static File getMinecraftDirectory() {
        if (Utils.isLogicalClient()) {
            return Minecraft.func_71410_x().field_71412_D;
        }
        return new File(".");
    }

    public static File getSubDirectory(String subdirectory) {
        return new File(Utils.getMinecraftDirectory(), subdirectory);
    }

    public static void deleteDirectoryRecursively(File targetDirectory) {
        try {
            Files.walk(targetDirectory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ByteBuffer readFileToBuffer(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            FileChannel inputChannel = inputStream.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)inputChannel.size());
            inputChannel.read(buffer);
            buffer.flip();
            inputChannel.close();
            inputStream.close();
            return buffer;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Short> readFileToMap(File file) {
        if (!file.exists()) {
            return new HashMap<String, Short>();
        }
        try {
            Gson gson = new Gson();
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            Map map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Short>>(){}.getType());
            ((Reader)reader).close();
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HashMap<String, Short>();
        }
    }

    public static void writeMapToFile(File file, Map<String, Short> map) {
        try {
            if (file.exists()) {
                file.delete();
            }
            Gson gson = new Gson();
            BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardOpenOption.CREATE_NEW);
            gson.toJson(map, new TypeToken<Map<String, Short>>(){}.getType(), (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void appendToFile(File file, ByteBuffer byteBuffer) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream outputStream = new FileOutputStream(file, true);
            FileChannel outputChannel = outputStream.getChannel();
            outputChannel.write(byteBuffer);
            outputChannel.close();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<Integer, ByteBuffer> getDIMFiles(File directory) {
        try {
            List dimensionIds = Files.walk(directory.toPath(), 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith("DIM")).map(dimensionFolder -> Integer.parseInt(dimensionFolder.getFileName().toString().substring(3))).collect(Collectors.toList());
            HashMap<Integer, ByteBuffer> dimensionFiles = new HashMap<Integer, ByteBuffer>();
            Iterator iterator = dimensionIds.iterator();
            while (iterator.hasNext()) {
                int dimensionId = (Integer)iterator.next();
                ByteBuffer buffer = Utils.readFileToBuffer(new File(directory.toPath() + "/DIM" + dimensionId));
                if (buffer == null) continue;
                dimensionFiles.put(dimensionId, buffer);
            }
            return dimensionFiles;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HashMap<Integer, ByteBuffer>();
        }
    }
}

