/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.DimensionCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class WorldCache {
    protected Map<Integer, DimensionCache> dimensions = new HashMap<Integer, DimensionCache>();
    private boolean needsSaving = false;
    protected File oreVeinCacheDirectory;
    protected File undergroundFluidCacheDirectory;
    private boolean isLoaded = false;

    protected abstract File getStorageDirectory();

    public boolean loadVeinCache(String worldId) {
        if (this.isLoaded) {
            return true;
        }
        this.isLoaded = true;
        File worldCacheDirectory = new File(this.getStorageDirectory(), worldId);
        this.oreVeinCacheDirectory = new File(worldCacheDirectory, "ore/");
        this.undergroundFluidCacheDirectory = new File(worldCacheDirectory, "fluids/");
        this.oreVeinCacheDirectory.mkdirs();
        this.undergroundFluidCacheDirectory.mkdirs();
        Map<Integer, ByteBuffer> oreVeinDimensionBuffers = Utils.getDIMFiles(this.oreVeinCacheDirectory);
        Map<Integer, ByteBuffer> undergroundFluidDimensionBuffers = Utils.getDIMFiles(this.undergroundFluidCacheDirectory);
        HashSet<Integer> dimensionsIds = new HashSet<Integer>();
        dimensionsIds.addAll(oreVeinDimensionBuffers.keySet());
        dimensionsIds.addAll(undergroundFluidDimensionBuffers.keySet());
        if (dimensionsIds.isEmpty()) {
            return false;
        }
        Iterator iterator = dimensionsIds.iterator();
        while (iterator.hasNext()) {
            int dimensionId = (Integer)iterator.next();
            DimensionCache dimension = new DimensionCache(dimensionId);
            dimension.loadCache(oreVeinDimensionBuffers.get(dimensionId), undergroundFluidDimensionBuffers.get(dimensionId));
            this.dimensions.put(dimensionId, dimension);
        }
        return true;
    }

    public void saveVeinCache() {
        if (this.needsSaving) {
            for (DimensionCache dimension : this.dimensions.values()) {
                ByteBuffer undergroundFluidBuffer;
                ByteBuffer oreVeinBuffer = dimension.saveOreChunks();
                if (oreVeinBuffer != null) {
                    Utils.appendToFile(new File(this.oreVeinCacheDirectory.toPath() + "/DIM" + dimension.dimensionId), oreVeinBuffer);
                }
                if ((undergroundFluidBuffer = dimension.saveUndergroundFluids()) == null) continue;
                Utils.appendToFile(new File(this.undergroundFluidCacheDirectory.toPath() + "/DIM" + dimension.dimensionId), undergroundFluidBuffer);
            }
            this.needsSaving = false;
        }
    }

    public void reset() {
        this.dimensions = new HashMap<Integer, DimensionCache>();
        this.needsSaving = false;
        this.isLoaded = false;
    }

    private DimensionCache.UpdateResult updateSaveFlag(DimensionCache.UpdateResult updateResult) {
        this.needsSaving |= updateResult != DimensionCache.UpdateResult.AlreadyKnown;
        return updateResult;
    }

    protected DimensionCache.UpdateResult putOreVein(OreVeinPosition oreVeinPosition) {
        DimensionCache dimension = this.dimensions.get(oreVeinPosition.dimensionId);
        if (dimension == null) {
            dimension = new DimensionCache(oreVeinPosition.dimensionId);
            this.dimensions.put(oreVeinPosition.dimensionId, dimension);
        }
        return this.updateSaveFlag(dimension.putOreVein(oreVeinPosition));
    }

    protected void toggleOreVein(int dimensionId, int chunkX, int chunkZ) {
        DimensionCache dimension = this.dimensions.get(dimensionId);
        if (dimension != null) {
            dimension.toggleOreVein(chunkX, chunkZ);
        }
        this.needsSaving = true;
    }

    public OreVeinPosition getOreVein(int dimensionId, int chunkX, int chunkZ) {
        DimensionCache dimension = this.dimensions.get(dimensionId);
        if (dimension == null) {
            return new OreVeinPosition(dimensionId, chunkX, chunkZ, VeinType.NO_VEIN, true);
        }
        return dimension.getOreVein(chunkX, chunkZ);
    }

    protected DimensionCache.UpdateResult putUndergroundFluids(UndergroundFluidPosition undergroundFluid) {
        DimensionCache dimension = this.dimensions.get(undergroundFluid.dimensionId);
        if (dimension == null) {
            dimension = new DimensionCache(undergroundFluid.dimensionId);
            this.dimensions.put(undergroundFluid.dimensionId, dimension);
        }
        return this.updateSaveFlag(dimension.putUndergroundFluid(undergroundFluid));
    }

    public UndergroundFluidPosition getUndergroundFluid(int dimensionId, int chunkX, int chunkZ) {
        DimensionCache dimension = this.dimensions.get(dimensionId);
        if (dimension == null) {
            return UndergroundFluidPosition.getNotProspected(dimensionId, chunkX, chunkZ);
        }
        return dimension.getUndergroundFluid(chunkX, chunkZ);
    }
}

