/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.cachebuilder.AnalysisProgressTracker;
import com.sinthoras.visualprospecting.database.cachebuilder.ChunkAnalysis;
import com.sinthoras.visualprospecting.database.cachebuilder.DetailedChunkAnalysis;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.MinecraftRegion;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.MinecraftWorld;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.DataFormatException;

public class DimensionAnalysis {
    public final int dimensionId;
    private final Map<Long, DetailedChunkAnalysis> chunksForSecondIdentificationPass = new ConcurrentHashMap<Long, DetailedChunkAnalysis>();

    public DimensionAnalysis(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void processMinecraftWorld(MinecraftWorld world) throws IOException {
        ConcurrentHashMap veinBlockY = new ConcurrentHashMap();
        List<File> regionFiles = world.getAllRegionFiles(this.dimensionId);
        AnalysisProgressTracker.setNumberOfRegionFiles(regionFiles.size());
        regionFiles.parallelStream().forEach(regionFile -> {
            try {
                String[] parts = regionFile.getName().split("\\.");
                int regionChunkX = Integer.parseInt(parts[1]) << 5;
                int regionChunkZ = Integer.parseInt(parts[2]) << 5;
                MinecraftRegion region = new MinecraftRegion((File)regionFile);
                for (int localChunkX = 0; localChunkX < 32; ++localChunkX) {
                    for (int localChunkZ = 0; localChunkZ < 32; ++localChunkZ) {
                        NBTCompound root;
                        int chunkX = regionChunkX + localChunkX;
                        int chunkZ = regionChunkZ + localChunkZ;
                        if (chunkX != Utils.mapToCenterOreChunkCoord(chunkX) || chunkZ != Utils.mapToCenterOreChunkCoord(chunkZ) || (root = region.getChunk(localChunkX, localChunkZ).getRootTag()) == null) continue;
                        ChunkAnalysis chunk = new ChunkAnalysis();
                        chunk.processMinecraftChunk(root);
                        if (chunk.matchesSingleVein()) {
                            ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunkX, chunkZ, chunk.getMatchedVein());
                            veinBlockY.put(Utils.chunkCoordsToKey(chunkX, chunkZ), chunk.getVeinBlockY());
                            continue;
                        }
                        DetailedChunkAnalysis detailedChunk = new DetailedChunkAnalysis(this.dimensionId, chunkX, chunkZ);
                        detailedChunk.processMinecraftChunk(root);
                        this.chunksForSecondIdentificationPass.put(Utils.chunkCoordsToKey(chunkX, chunkZ), detailedChunk);
                    }
                }
                region.close();
                AnalysisProgressTracker.regionFileProcessed();
            }
            catch (IOException | DataFormatException e) {
                AnalysisProgressTracker.notifyCorruptFile(regionFile);
            }
        });
        this.chunksForSecondIdentificationPass.keySet().parallelStream().forEach(key -> {
            DetailedChunkAnalysis chunk = this.chunksForSecondIdentificationPass.get(key);
            chunk.cleanUpWithNeighbors(veinBlockY);
            ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunk.chunkX, chunk.chunkZ, chunk.getMatchedVein());
        });
    }
}

