/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.sinthoras.visualprospecting.integration.model.SupportedMods;
import com.sinthoras.visualprospecting.integration.model.buttons.ButtonManager;
import com.sinthoras.visualprospecting.integration.model.buttons.LayerButton;
import com.sinthoras.visualprospecting.integration.model.layers.LayerRenderer;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public abstract class LayerManager {
    private final ButtonManager buttonManager;
    private boolean isLayerActive = false;
    protected boolean forceRefresh = false;
    private List<? extends ILocationProvider> visibleElements = new ArrayList<ILocationProvider>();
    protected Map<SupportedMods, LayerRenderer> layerRenderer = new EnumMap<SupportedMods, LayerRenderer>(SupportedMods.class);

    public LayerManager(ButtonManager buttonManager) {
        this.buttonManager = buttonManager;
    }

    public void onButtonClicked(LayerButton button) {
        if (this.buttonManager.containsButton(button)) {
            this.toggleLayer();
        }
    }

    public boolean isLayerActive() {
        return this.buttonManager.isActive();
    }

    public void activateLayer() {
        this.buttonManager.activate();
    }

    public void deactivateLayer() {
        this.buttonManager.deactivate();
    }

    public void toggleLayer() {
        this.buttonManager.toggle();
    }

    public void forceRefresh() {
        this.forceRefresh = true;
    }

    public void onOpenMap() {
    }

    protected abstract List<? extends ILocationProvider> generateVisibleElements(int var1, int var2, int var3, int var4);

    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return true;
    }

    public void recacheVisibleElements(int centerBlockX, int centerBlockZ, int widthBlocks, int heightBlocks) {
        int radiusBlockX = widthBlocks + 1 >> 1;
        int radiusBlockZ = heightBlocks + 1 >> 1;
        int minBlockX = centerBlockX - radiusBlockX;
        int minBlockZ = centerBlockZ - radiusBlockZ;
        int maxBlockX = centerBlockX + radiusBlockX;
        int maxBlockZ = centerBlockZ + radiusBlockZ;
        if (this.forceRefresh || this.needsRegenerateVisibleElements(minBlockX, minBlockZ, maxBlockX, maxBlockZ)) {
            this.visibleElements = this.generateVisibleElements(minBlockX, minBlockZ, maxBlockX, maxBlockZ);
            this.layerRenderer.values().forEach(layer -> layer.updateVisibleElements(this.visibleElements));
            this.forceRefresh = false;
        }
    }

    public void registerLayerRenderer(SupportedMods map, LayerRenderer renderer) {
        this.layerRenderer.put(map, renderer);
    }

    public LayerRenderer getLayerRenderer(SupportedMods map) {
        return this.layerRenderer.get((Object)map);
    }
}

