/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.network;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.TransferCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ProspectionSharing
implements IMessage {
    private static final int BYTES_OVERHEAD = 10;
    final List<OreVeinPosition> oreVeins = new ArrayList<OreVeinPosition>();
    final List<UndergroundFluidPosition> undergroundFluids = new ArrayList<UndergroundFluidPosition>();
    private int bytesUsed = 10;
    boolean isFirstMessage = false;
    boolean isLastMessage = false;

    public int putOreVeins(List<OreVeinPosition> oreVeins) {
        int availableBytes = Config.uploadSizePerPacket - this.bytesUsed;
        int maxAddedOreVeins = availableBytes / OreVeinPosition.getMaxBytes();
        int addedOreVeins = Math.min(oreVeins.size(), maxAddedOreVeins);
        this.oreVeins.addAll(oreVeins.subList(0, addedOreVeins));
        this.bytesUsed += addedOreVeins * OreVeinPosition.getMaxBytes();
        return addedOreVeins;
    }

    public int putOreUndergroundFluids(List<UndergroundFluidPosition> undergroundFluids) {
        int availableBytes = Config.uploadSizePerPacket - this.bytesUsed;
        int maxAddedUndergroundFluids = availableBytes / 272;
        int addedUndergroundFluids = Math.min(undergroundFluids.size(), maxAddedUndergroundFluids);
        this.undergroundFluids.addAll(undergroundFluids.subList(0, addedUndergroundFluids));
        this.bytesUsed += addedUndergroundFluids * 272;
        return addedUndergroundFluids;
    }

    public void setFirstMessage(boolean isFirstMessage) {
        this.isFirstMessage = isFirstMessage;
    }

    public void setLastMessage(boolean isLastMessage) {
        this.isLastMessage = isLastMessage;
    }

    public int getBytes() {
        return 10 + VeinTypeCaching.getLongesOreNameLength() * this.oreVeins.size() + 272 * this.undergroundFluids.size();
    }

    public void fromBytes(ByteBuf buf) {
        this.isFirstMessage = buf.readByte() > 0;
        this.isLastMessage = buf.readByte() > 0;
        int numberOfOreVeins = buf.readInt();
        for (int i = 0; i < numberOfOreVeins; ++i) {
            int dimensionId = buf.readInt();
            int chunkX = buf.readInt();
            int chunkZ = buf.readInt();
            boolean isDepleted = buf.readByte() > 0;
            String oreVeinName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.oreVeins.add(new OreVeinPosition(dimensionId, chunkX, chunkZ, VeinTypeCaching.getVeinType(oreVeinName), isDepleted));
        }
        int numberOfUndergroundFluids = buf.readInt();
        for (int i = 0; i < numberOfUndergroundFluids; ++i) {
            int dimensionId = buf.readInt();
            int chunkX = buf.readInt();
            int chunkZ = buf.readInt();
            Fluid fluid = FluidRegistry.getFluid((int)buf.readInt());
            int[][] chunks = new int[8][8];
            for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                    chunks[offsetChunkX][offsetChunkZ] = buf.readInt();
                }
            }
            this.undergroundFluids.add(new UndergroundFluidPosition(dimensionId, chunkX, chunkZ, fluid, chunks));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.isFirstMessage ? 1 : 0);
        buf.writeByte(this.isLastMessage ? 1 : 0);
        buf.writeInt(this.oreVeins.size());
        for (OreVeinPosition oreVein : this.oreVeins) {
            buf.writeInt(oreVein.dimensionId);
            buf.writeInt(oreVein.chunkX);
            buf.writeInt(oreVein.chunkZ);
            buf.writeByte(oreVein.isDepleted() ? 1 : 0);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)oreVein.veinType.name);
        }
        buf.writeInt(this.undergroundFluids.size());
        for (UndergroundFluidPosition undergroundFluid : this.undergroundFluids) {
            buf.writeInt(undergroundFluid.dimensionId);
            buf.writeInt(undergroundFluid.chunkX);
            buf.writeInt(undergroundFluid.chunkZ);
            buf.writeInt(undergroundFluid.fluid.getID());
            for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                    buf.writeInt(undergroundFluid.chunks[offsetChunkX][offsetChunkZ]);
                }
            }
        }
    }

    public static class ClientHandler
    implements IMessageHandler<ProspectionSharing, IMessage> {
        private static List<OreVeinPosition> oreVeins;
        private static List<UndergroundFluidPosition> undergroundFluids;

        public IMessage onMessage(ProspectionSharing message, MessageContext ctx) {
            if (message.isFirstMessage) {
                oreVeins = new ArrayList<OreVeinPosition>();
                undergroundFluids = new ArrayList<UndergroundFluidPosition>();
            }
            if (oreVeins == null || undergroundFluids == null) {
                return null;
            }
            oreVeins.addAll(message.oreVeins);
            undergroundFluids.addAll(message.undergroundFluids);
            if (message.isLastMessage) {
                ClientCache.instance.putOreVeins(oreVeins);
                ClientCache.instance.putUndergroundFluids(undergroundFluids);
            }
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<ProspectionSharing, IMessage> {
        private static Map<EntityPlayerMP, List<OreVeinPosition>> oreVeins = new HashMap<EntityPlayerMP, List<OreVeinPosition>>();
        private static Map<EntityPlayerMP, List<UndergroundFluidPosition>> undergroundFluids = new HashMap<EntityPlayerMP, List<UndergroundFluidPosition>>();

        public IMessage onMessage(ProspectionSharing message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.getBytes() > Config.uploadSizePerPacket) {
                player.field_71135_a.func_147360_c("Do not spam the server! Change your VisualProcessing configuration back to the servers!");
            }
            if (message.isFirstMessage) {
                oreVeins.put(player, new ArrayList());
                undergroundFluids.put(player, new ArrayList());
            }
            if (!oreVeins.containsKey(player) || !undergroundFluids.containsKey(player)) {
                return null;
            }
            oreVeins.get(player).addAll(message.oreVeins);
            undergroundFluids.get(player).addAll(message.undergroundFluids);
            if (message.isLastMessage) {
                TransferCache.instance.addClientProspectionData(player.getPersistentID().toString(), oreVeins.get(player), undergroundFluids.get(player));
                oreVeins.remove(player);
                undergroundFluids.remove(player);
            }
            return null;
        }
    }
}

