/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt;

import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class NBTFile {
    private final NBTCompound root;

    public NBTFile(File file, CompressionScheme scheme) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        FileInputStream fis = new FileInputStream(file);
        if (scheme == CompressionScheme.GZIPPED) {
            GZIPInputStream zis = new GZIPInputStream(fis);
            this.root = (NBTCompound)NBTag.parseInputStream(zis);
        } else if (scheme == CompressionScheme.NONE) {
            this.root = (NBTCompound)NBTag.parseInputStream(fis);
        } else {
            fis.close();
            throw new RuntimeException("Unknown CompressionScheme: " + (Object)((Object)scheme));
        }
    }

    public NBTCompound getRoot() {
        return this.root;
    }

    public static enum CompressionScheme {
        NONE,
        GZIPPED;

    }
}

