/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.task;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.TransferCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.network.ProspectionSharing;
import com.sinthoras.visualprospecting.task.ITask;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class SnapshotDownloadTask
implements ITask {
    private final EntityPlayerMP player;
    private final List<OreVeinPosition> oreVeins;
    private final List<UndergroundFluidPosition> undergroundFluids;
    private long lastUpload = 0L;
    private boolean firstMessage = true;

    public SnapshotDownloadTask(String authorUuid, EntityPlayerMP player) {
        this.player = player;
        this.oreVeins = TransferCache.instance.getSharedOreVeinsFrom(authorUuid);
        this.undergroundFluids = TransferCache.instance.getSharedUndergroundFluidsFrom(authorUuid);
    }

    @Override
    public boolean process() {
        long timestamp = System.currentTimeMillis();
        if (timestamp - this.lastUpload > 100L && !this.listsEmpty()) {
            this.lastUpload = timestamp;
            ProspectionSharing packet = new ProspectionSharing();
            int addedOreVeins = packet.putOreVeins(this.oreVeins);
            this.oreVeins.subList(0, addedOreVeins).clear();
            int addedUndergroundFluids = packet.putOreUndergroundFluids(this.undergroundFluids);
            this.undergroundFluids.subList(0, addedUndergroundFluids).clear();
            packet.setFirstMessage(this.firstMessage);
            this.firstMessage = false;
            packet.setLastMessage(this.listsEmpty());
            VP.network.sendTo((IMessage)packet, this.player);
            if (this.listsEmpty()) {
                ChatComponentTranslation notification = new ChatComponentTranslation("visualprospecting.prospectorslog.reading.end", new Object[]{this.player.getDisplayName()});
                notification.func_150256_b().func_150217_b(Boolean.valueOf(true));
                notification.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                this.player.func_145747_a((IChatComponent)notification);
            }
        }
        return this.listsEmpty();
    }

    private boolean listsEmpty() {
        return this.oreVeins.isEmpty() && this.undergroundFluids.isEmpty();
    }
}

