/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.task;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.network.ProspectionSharing;
import com.sinthoras.visualprospecting.task.ITask;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;

public class SnapshotUploadTask
implements ITask {
    private final List<OreVeinPosition> oreVeins = ClientCache.instance.getAllOreVeins();
    private final List<UndergroundFluidPosition> undergroundFluids = ClientCache.instance.getAllUndergroundFluids();
    private long lastUpload = 0L;
    private boolean firstMessage = true;

    @Override
    public boolean process() {
        long timestamp = System.currentTimeMillis();
        if (timestamp - this.lastUpload > 100L && !this.listsEmpty()) {
            this.lastUpload = timestamp;
            ProspectionSharing packet = new ProspectionSharing();
            int addedOreVeins = packet.putOreVeins(this.oreVeins);
            this.oreVeins.subList(0, addedOreVeins).clear();
            int addedUndergroundFluids = packet.putOreUndergroundFluids(this.undergroundFluids);
            this.undergroundFluids.subList(0, addedUndergroundFluids).clear();
            packet.setFirstMessage(this.firstMessage);
            this.firstMessage = false;
            packet.setLastMessage(this.listsEmpty());
            VP.network.sendToServer((IMessage)packet);
        }
        return this.listsEmpty();
    }

    private boolean listsEmpty() {
        return this.oreVeins.isEmpty() && this.undergroundFluids.isEmpty();
    }
}

