/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class DimensionCache {
    private final Map<ChunkCoordIntPair, OreVeinPosition> oreChunks = new HashMap<ChunkCoordIntPair, OreVeinPosition>();
    private final Map<ChunkCoordIntPair, UndergroundFluidPosition> undergroundFluids = new HashMap<ChunkCoordIntPair, UndergroundFluidPosition>();
    private final Set<ChunkCoordIntPair> changedOrNewOreChunks = new HashSet<ChunkCoordIntPair>();
    private final Set<ChunkCoordIntPair> changedOrNewUndergroundFluids = new HashSet<ChunkCoordIntPair>();
    public final int dimensionId;

    public DimensionCache(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public ByteBuffer saveOreChunks() {
        if (!this.changedOrNewOreChunks.isEmpty()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.changedOrNewOreChunks.size() * 10);
            this.changedOrNewOreChunks.stream().map(this.oreChunks::get).forEach(oreVeinPosition -> {
                byteBuffer.putInt(oreVeinPosition.chunkX);
                byteBuffer.putInt(oreVeinPosition.chunkZ);
                short veinTypeId = VeinTypeCaching.getVeinTypeId(oreVeinPosition.veinType);
                if (oreVeinPosition.isDepleted()) {
                    veinTypeId = (short)(veinTypeId | 0x8000);
                }
                byteBuffer.putShort(veinTypeId);
            });
            this.changedOrNewOreChunks.clear();
            byteBuffer.flip();
            return byteBuffer;
        }
        return null;
    }

    public ByteBuffer saveUndergroundFluids() {
        if (!this.changedOrNewUndergroundFluids.isEmpty()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.changedOrNewUndergroundFluids.size() * 268);
            this.changedOrNewUndergroundFluids.stream().map(this.undergroundFluids::get).forEach(undergroundFluidPosition -> {
                byteBuffer.putInt(undergroundFluidPosition.chunkX);
                byteBuffer.putInt(undergroundFluidPosition.chunkZ);
                byteBuffer.putInt(undergroundFluidPosition.fluid.getID());
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        byteBuffer.putInt(undergroundFluidPosition.chunks[offsetChunkX][offsetChunkZ]);
                    }
                }
            });
            this.changedOrNewUndergroundFluids.clear();
            byteBuffer.flip();
            return byteBuffer;
        }
        return null;
    }

    public void loadCache(ByteBuffer oreChunksBuffer, ByteBuffer undergroundFluidsBuffer) {
        int chunkZ;
        int chunkX;
        if (oreChunksBuffer != null) {
            while (oreChunksBuffer.remaining() >= 10) {
                chunkX = oreChunksBuffer.getInt();
                chunkZ = oreChunksBuffer.getInt();
                short veinTypeId = oreChunksBuffer.getShort();
                boolean depleted = (veinTypeId & 0x8000) > 0;
                VeinType veinType = VeinTypeCaching.getVeinType((short)(veinTypeId & Short.MAX_VALUE));
                this.oreChunks.put(this.getOreVeinKey(chunkX, chunkZ), new OreVeinPosition(this.dimensionId, chunkX, chunkZ, veinType, depleted));
            }
        }
        if (undergroundFluidsBuffer != null) {
            while (undergroundFluidsBuffer.remaining() >= 268) {
                chunkX = undergroundFluidsBuffer.getInt();
                chunkZ = undergroundFluidsBuffer.getInt();
                Fluid fluid = FluidRegistry.getFluid((int)undergroundFluidsBuffer.getInt());
                int[][] chunks = new int[8][8];
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        chunks[offsetChunkX][offsetChunkZ] = undergroundFluidsBuffer.getInt();
                    }
                }
                this.undergroundFluids.put(this.getUndergroundFluidKey(chunkX, chunkZ), new UndergroundFluidPosition(this.dimensionId, chunkX, chunkZ, fluid, chunks));
            }
        }
    }

    private ChunkCoordIntPair getOreVeinKey(int chunkX, int chunkZ) {
        return new ChunkCoordIntPair(Utils.mapToCenterOreChunkCoord(chunkX), Utils.mapToCenterOreChunkCoord(chunkZ));
    }

    public UpdateResult putOreVein(OreVeinPosition oreVeinPosition) {
        ChunkCoordIntPair key = this.getOreVeinKey(oreVeinPosition.chunkX, oreVeinPosition.chunkZ);
        if (!this.oreChunks.containsKey(key)) {
            this.oreChunks.put(key, oreVeinPosition);
            this.changedOrNewOreChunks.add(key);
            return UpdateResult.New;
        }
        OreVeinPosition storedOreVeinPosition = this.oreChunks.get(key);
        if (storedOreVeinPosition.veinType != oreVeinPosition.veinType) {
            this.oreChunks.put(key, oreVeinPosition.joinDepletedState(storedOreVeinPosition));
            this.changedOrNewOreChunks.add(key);
            return UpdateResult.New;
        }
        return UpdateResult.AlreadyKnown;
    }

    public void toggleOreVein(int chunkX, int chunkZ) {
        ChunkCoordIntPair key = this.getOreVeinKey(chunkX, chunkZ);
        if (this.oreChunks.containsKey(key)) {
            this.oreChunks.get(key).toggleDepleted();
            this.changedOrNewOreChunks.add(key);
        }
    }

    public OreVeinPosition getOreVein(int chunkX, int chunkZ) {
        ChunkCoordIntPair key = this.getOreVeinKey(chunkX, chunkZ);
        return this.oreChunks.getOrDefault(key, new OreVeinPosition(this.dimensionId, chunkX, chunkZ, VeinType.NO_VEIN, true));
    }

    private ChunkCoordIntPair getUndergroundFluidKey(int chunkX, int chunkZ) {
        return new ChunkCoordIntPair(Utils.mapToCornerUndergroundFluidChunkCoord(chunkX), Utils.mapToCornerUndergroundFluidChunkCoord(chunkZ));
    }

    public UpdateResult putUndergroundFluid(UndergroundFluidPosition undergroundFluid) {
        ChunkCoordIntPair key = this.getUndergroundFluidKey(undergroundFluid.chunkX, undergroundFluid.chunkZ);
        if (!this.undergroundFluids.containsKey(key)) {
            this.changedOrNewUndergroundFluids.add(key);
            this.undergroundFluids.put(key, undergroundFluid);
            return UpdateResult.New;
        }
        if (!this.undergroundFluids.get(key).equals(undergroundFluid)) {
            this.changedOrNewUndergroundFluids.add(key);
            this.undergroundFluids.put(key, undergroundFluid);
            return UpdateResult.Updated;
        }
        return UpdateResult.AlreadyKnown;
    }

    public UndergroundFluidPosition getUndergroundFluid(int chunkX, int chunkZ) {
        ChunkCoordIntPair key = this.getUndergroundFluidKey(chunkX, chunkZ);
        return this.undergroundFluids.getOrDefault(key, UndergroundFluidPosition.getNotProspected(this.dimensionId, chunkX, chunkZ));
    }

    public Collection<OreVeinPosition> getAllOreVeins() {
        return this.oreChunks.values();
    }

    public Collection<UndergroundFluidPosition> getAllUndergroundFluids() {
        return this.undergroundFluids.values();
    }

    public static enum UpdateResult {
        AlreadyKnown,
        Updated,
        New;

    }
}

