/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.xaeroworldmap.renderers;

import com.sinthoras.visualprospecting.integration.model.layers.WaypointProviderManager;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.renderers.LayerRenderer;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.InteractableRenderStep;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.rendersteps.RenderStep;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;

public abstract class InteractableLayerRenderer
extends LayerRenderer {
    private double mouseXForRender;
    private double mouseYForRender;
    protected WaypointProviderManager manager;
    protected InteractableRenderStep hovered;

    public InteractableLayerRenderer(WaypointProviderManager manager) {
        super(manager);
        this.manager = manager;
        this.hovered = null;
    }

    protected abstract List<? extends InteractableRenderStep> generateRenderSteps(List<? extends ILocationProvider> var1);

    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        this.mouseXForRender = mouseX - cameraX;
        this.mouseYForRender = mouseY - cameraZ;
        for (RenderStep step : this.renderStepsReversed) {
            if (!(step instanceof InteractableRenderStep) || !((InteractableRenderStep)step).isMouseOver(this.mouseXForRender, this.mouseYForRender, scale)) continue;
            this.hovered = (InteractableRenderStep)step;
            return;
        }
        this.hovered = null;
    }

    public void drawTooltip(GuiScreen gui, double scale, int scaleAdj) {
        if (this.hovered != null) {
            this.hovered.drawTooltip(gui, this.mouseXForRender, this.mouseYForRender, scale, scaleAdj);
        }
    }

    public void doActionKeyPress() {
        if (this.manager.isLayerActive() && this.hovered != null) {
            this.hovered.onActionButton();
            this.manager.forceRefresh();
        }
    }

    public void doDoubleClick() {
        if (this.hovered != null) {
            if (this.hovered.getLocationProvider().isActiveAsWaypoint()) {
                this.manager.clearActiveWaypoint();
            } else {
                this.manager.setActiveWaypoint(this.hovered.getLocationProvider().toWaypoint());
            }
        }
    }
}

