/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.shadow.io.xol.enklume;

import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTByte;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTByteArray;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTNamed;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTag;
import java.io.ByteArrayInputStream;

public class MinecraftChunk {
    NBTCompound root = null;
    int[] sectionsMap = new int[16];
    public final int x;
    public final int z;
    byte[][] blocks = new byte[16][];
    byte[][] mData = new byte[16][];

    public MinecraftChunk(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public MinecraftChunk(int x, int z, byte[] byteArray) {
        this(x, z);
        int i;
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        this.root = (NBTCompound)NBTag.parseInputStream(bais);
        for (i = 0; i < 16; ++i) {
            this.sectionsMap[i] = -1;
        }
        for (i = 0; i < 16; ++i) {
            NBTCompound section = (NBTCompound)this.root.getTag("Level.Sections." + i);
            if (section == null) continue;
            byte y = ((NBTByte)section.getTag((String)"Y")).data;
            this.sectionsMap[y] = i;
            NBTNamed blocksNBT = this.root.getTag("Level.Sections." + i + ".Blocks");
            if (blocksNBT == null) continue;
            this.blocks[i] = ((NBTByteArray)blocksNBT).data;
        }
        for (i = 0; i < 16; ++i) {
            NBTNamed mDataNBT;
            NBTNamed blocksNBT = this.root.getTag("Level.Sections." + i + ".Blocks");
            if (blocksNBT != null) {
                this.blocks[i] = ((NBTByteArray)blocksNBT).data;
            }
            if ((mDataNBT = this.root.getTag("Level.Sections." + i + ".Data")) == null) continue;
            this.mData[i] = ((NBTByteArray)mDataNBT).data;
        }
    }

    public NBTCompound getRootTag() {
        return this.root;
    }

    public int getBlockID(int x, int y, int z) {
        NBTNamed blocksNBT;
        if (this.root == null) {
            return 0;
        }
        int i = this.sectionsMap[y / 16];
        if (y > 0 && y < 256 && i >= 0 && this.blocks[i] != null) {
            int index = (y %= 16) * 16 * 16 + z * 16 + x;
            return this.blocks[i][index] & 0xFF;
        }
        if (i >= 0 && (blocksNBT = this.root.getTag("Level.Sections." + i + ".Blocks")) != null) {
            int index = (y %= 16) * 16 * 16 + z * 16 + x;
            return ((NBTByteArray)blocksNBT).data[index] & 0xFF;
        }
        return 0;
    }

    public int getBlockMeta(int x, int y, int z) {
        int i = this.sectionsMap[y / 16];
        if (y > 0 && y < 256 && i >= 0 && this.mData[i] != null) {
            int index = (y %= 16) * 16 * 16 + z * 16 + x;
            byte unfilteredMeta = this.mData[i][index / 2];
            if (index % 2 != 0) {
                return unfilteredMeta >> 4 & 0xF;
            }
            return unfilteredMeta & 0xF;
        }
        return 0;
    }
}

