/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt;

import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTByte;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTByteArray;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTDouble;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTEnd;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTFloat;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTInt;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTIntArray;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTList;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTLong;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTNamed;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTShort;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTString;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class NBTag {
    static Type lastType;

    abstract void feed(DataInputStream var1) throws IOException;

    public static NBTag parseInputStream(InputStream bais) {
        try {
            int type = bais.read();
            if (type == -1) {
                return null;
            }
            NBTag tag = NBTag.create(type);
            tag.feed(new DataInputStream(bais));
            return tag;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static NBTag createNamedFromList(int t, int listIndex) {
        NBTag tag = NBTag.create(Type.values()[t]);
        if (tag instanceof NBTNamed) {
            NBTNamed named = (NBTNamed)tag;
            named.setNamedFromListIndex(listIndex);
            return named;
        }
        System.out.println("Error: Type " + t + " (" + Type.values()[t].name() + ") can't be named.");
        return tag;
    }

    public static NBTag create(int t) throws IOException {
        try {
            NBTag tag = NBTag.create(Type.values()[t]);
            lastType = Type.values()[t];
            return tag;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Out of bounds type exception: " + t + " Last valid type was : " + (Object)((Object)lastType) + ". Probably caused by a corrupt file. Will ignore this particular NBT entry!");
            throw new IOException("Corrupted File");
        }
    }

    private static NBTag create(Type t) {
        switch (t) {
            case TAG_END: {
                return new NBTEnd();
            }
            case TAG_COMPOUND: {
                return new NBTCompound();
            }
            case TAG_BYTE: {
                return new NBTByte();
            }
            case TAG_SHORT: {
                return new NBTShort();
            }
            case TAG_INT: {
                return new NBTInt();
            }
            case TAG_FLOAT: {
                return new NBTFloat();
            }
            case TAG_DOUBLE: {
                return new NBTDouble();
            }
            case TAG_STRING: {
                return new NBTString();
            }
            case TAG_LONG: {
                return new NBTLong();
            }
            case TAG_LIST: {
                return new NBTList();
            }
            case TAG_BYTE_ARRAY: {
                return new NBTByteArray();
            }
            case TAG_INT_ARRAY: {
                return new NBTIntArray();
            }
        }
        System.out.println("Unknow type : " + t.name());
        return null;
    }

    public static enum Type {
        TAG_END,
        TAG_BYTE,
        TAG_SHORT,
        TAG_INT,
        TAG_LONG,
        TAG_FLOAT,
        TAG_DOUBLE,
        TAG_BYTE_ARRAY,
        TAG_STRING,
        TAG_LIST,
        TAG_COMPOUND,
        TAG_INT_ARRAY;

    }
}

