/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.mixins.gregtech;

import com.sinthoras.visualprospecting.ServerTranslations;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.ServerCache;
import gregtech.api.interfaces.ITexture;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_Scanner;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GT_MetaTileEntity_Scanner.class}, remap=false)
public abstract class GT_MetaTileEntity_ScannerMixin
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_ScannerMixin() {
        super(0, "", "", 0, 0, "", 0, 0, "", "", (ITexture[])null);
    }

    @Inject(method={"checkRecipe"}, at={@At(value="INVOKE", target="Lgregtech/api/util/GT_Utility$ItemNBT;convertProspectionData(Lnet/minecraft/item/ItemStack;)V")}, remap=false, require=1, cancellable=true)
    private void onAnalyzeProspectionData(CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        ItemStack itemStack = this.getInputAt(0);
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound.func_74764_b("is_visualprospecting_data")) {
            int dimensionId = compound.func_74762_e("prospection_dimension_id");
            int blockX = compound.func_74762_e("prospection_block_x");
            int blockY = compound.func_74762_e("prospection_block_y");
            int blockZ = compound.func_74762_e("prospection_block_z");
            int blockRadius = compound.func_74762_e("prospection_ore_radius");
            int numberOfUndergroundFluids = compound.func_74762_e("prospection_num_fluids");
            String position = "Dim: " + dimensionId + " X: " + blockX + " Y: " + blockY + " Z: " + blockZ;
            NBTTagList bookPages = new NBTTagList();
            String frontPage = "Prospector report\n" + position + "\n\nFluids: " + numberOfUndergroundFluids + "\n\nOres within " + blockRadius + " blocks\n\nLocation is center of orevein\n\nResults are synchronized to your map";
            bookPages.func_74742_a((NBTBase)new NBTTagString(frontPage));
            List<OreVeinPosition> foundOreVeins = ServerCache.instance.prospectOreBlockRadius(dimensionId, blockX, blockZ, blockRadius);
            if (!foundOreVeins.isEmpty()) {
                int pageSize = 7;
                int numberOfPages = (foundOreVeins.size() + 7) / 7;
                for (int pageNumber = 0; pageNumber < numberOfPages; ++pageNumber) {
                    StringBuilder pageString = new StringBuilder();
                    for (int i = 0; i < 7; ++i) {
                        int veinId = pageNumber * 7 + i;
                        if (veinId >= foundOreVeins.size()) continue;
                        OreVeinPosition oreVein = foundOreVeins.get(veinId);
                        pageString.append(oreVein.getBlockX()).append(",").append(oreVein.getBlockZ()).append(" - ").append(ServerTranslations.getEnglishLocalization(oreVein.veinType)).append("\n");
                    }
                    String pageCounter = numberOfPages > 1 ? String.format(" %d/%d", pageNumber + 1, numberOfPages) : "";
                    NBTTagString pageTag = new NBTTagString(String.format("Ore Veins %s\n\n", pageCounter) + pageString);
                    bookPages.func_74742_a((NBTBase)pageTag);
                }
            }
            if (compound.func_74764_b("prospection_fluids")) {
                GT_Utility.ItemNBT.fillBookWithList((NBTTagList)bookPages, (String)"Fluids%s\n\n", (String)"\n", (int)9, (String[])compound.func_74779_i("prospection_fluids").split("\\|"));
                String fluidCoverPage = "Fluid notes\n\nProspects from NW to SE 576 chunks(9 8x8 fields)\n around and gives min-max amount\n\n[1][2][3]\n[4][5][6]\n[7][8][9]\n\n[5] - Prospector in this 8x8 area";
                bookPages.func_74742_a((NBTBase)new NBTTagString("Fluid notes\n\nProspects from NW to SE 576 chunks(9 8x8 fields)\n around and gives min-max amount\n\n[1][2][3]\n[4][5][6]\n[7][8][9]\n\n[5] - Prospector in this 8x8 area"));
                String tFluidsPosStr = "X: " + Math.floorDiv(blockX, 128) * 16 * 8 + " Z: " + Math.floorDiv(blockZ, 128) * 16 * 8 + "\n";
                int xOff = blockX - Math.floorDiv(blockX, 128) * 16 * 8;
                int xOffRemain = 7 - (xOff /= 16);
                int zOff = blockZ - Math.floorDiv(blockZ, 128) * 16 * 8;
                int zOffRemain = 7 - (zOff /= 16);
                while (zOff > 0) {
                    tFluidsPosStr = tFluidsPosStr.concat("--------\n");
                    --zOff;
                }
                while (xOff > 0) {
                    tFluidsPosStr = tFluidsPosStr.concat("-");
                    --xOff;
                }
                tFluidsPosStr = tFluidsPosStr.concat("P");
                while (xOffRemain > 0) {
                    tFluidsPosStr = tFluidsPosStr.concat("-");
                    --xOffRemain;
                }
                tFluidsPosStr = tFluidsPosStr.concat("\n");
                while (zOffRemain > 0) {
                    tFluidsPosStr = tFluidsPosStr.concat("--------\n");
                    --zOffRemain;
                }
                tFluidsPosStr = tFluidsPosStr.concat("            X: " + (Math.floorDiv(blockX, 128) + 1) * 16 * 8 + " Z: " + (Math.floorDiv(blockZ, 128) + 1) * 16 * 8);
                String fluidsPage = "Corners of [5] are \n" + tFluidsPosStr + "\nP - Prospector in 8x8 field";
                bookPages.func_74742_a((NBTBase)new NBTTagString(fluidsPage));
            }
            compound.func_74778_a("author", position);
            compound.func_74782_a("pages", (NBTBase)bookPages);
            GT_Utility.ItemNBT.setNBT((ItemStack)itemStack, (NBTTagCompound)compound);
            --itemStack.field_77994_a;
            this.mOutputItems[0] = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{itemStack});
            this.calculateOverclockedNess(30, 1000);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                callbackInfoReturnable.setReturnValue((Object)1);
            } else {
                callbackInfoReturnable.setReturnValue((Object)2);
            }
        }
    }
}

