/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class DimensionCache {
    private final Map<ChunkCoordIntPair, OreVeinPosition> oreChunks = new HashMap<ChunkCoordIntPair, OreVeinPosition>();
    private final Map<ChunkCoordIntPair, UndergroundFluidPosition> undergroundFluids = new HashMap<ChunkCoordIntPair, UndergroundFluidPosition>();
    private final Set<ChunkCoordIntPair> changedOrNewOreChunks = new HashSet<ChunkCoordIntPair>();
    private final Set<ChunkCoordIntPair> changedOrNewUndergroundFluids = new HashSet<ChunkCoordIntPair>();
    public final int dimensionId;

    public DimensionCache(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public ByteBuffer saveOreChunks() {
        if (!this.changedOrNewOreChunks.isEmpty()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.changedOrNewOreChunks.size() * 10);
            this.changedOrNewOreChunks.stream().map(this.oreChunks::get).forEach(oreVeinPosition -> {
                byteBuffer.putInt(oreVeinPosition.chunkX);
                byteBuffer.putInt(oreVeinPosition.chunkZ);
                short veinTypeId = VeinTypeCaching.getVeinTypeId(oreVeinPosition.veinType);
                if (oreVeinPosition.isDepleted()) {
                    veinTypeId = (short)(veinTypeId | 0x8000);
                }
                byteBuffer.putShort(veinTypeId);
            });
            this.changedOrNewOreChunks.clear();
            byteBuffer.flip();
            return byteBuffer;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer saveUndergroundFluids() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadCache(ByteBuffer oreChunksBuffer, ByteBuffer undergroundFluidsBuffer) {
        int chunkZ;
        int chunkX;
        if (oreChunksBuffer != null) {
            while (oreChunksBuffer.remaining() >= 10) {
                chunkX = oreChunksBuffer.getInt();
                chunkZ = oreChunksBuffer.getInt();
                short veinTypeId = oreChunksBuffer.getShort();
                boolean depleted = (veinTypeId & 0x8000) > 0;
                VeinType veinType = VeinTypeCaching.getVeinType((short)(veinTypeId & Short.MAX_VALUE));
                this.oreChunks.put(this.getOreVeinKey(chunkX, chunkZ), new OreVeinPosition(this.dimensionId, chunkX, chunkZ, veinType, depleted));
            }
        }
        if (undergroundFluidsBuffer != null) {
            while (undergroundFluidsBuffer.remaining() >= 268) {
                Fluid fluid;
                chunkX = undergroundFluidsBuffer.getInt();
                chunkZ = undergroundFluidsBuffer.getInt();
                int fluidIDorNameLength = undergroundFluidsBuffer.getInt();
                if (fluidIDorNameLength < 0) {
                    byte[] fluidNameBytes = new byte[-fluidIDorNameLength];
                    undergroundFluidsBuffer.get(fluidNameBytes);
                    String fluidName = new String(fluidNameBytes, StandardCharsets.UTF_8);
                    fluid = FluidRegistry.getFluid((String)fluidName);
                } else {
                    fluid = FluidRegistry.getFluid((int)fluidIDorNameLength);
                }
                int[][] chunks = new int[8][8];
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        chunks[offsetChunkX][offsetChunkZ] = undergroundFluidsBuffer.getInt();
                    }
                }
                if (fluid == null) continue;
                this.undergroundFluids.put(this.getUndergroundFluidKey(chunkX, chunkZ), new UndergroundFluidPosition(this.dimensionId, chunkX, chunkZ, fluid, chunks));
            }
        }
    }

    private ChunkCoordIntPair getOreVeinKey(int chunkX, int chunkZ) {
        return new ChunkCoordIntPair(Utils.mapToCenterOreChunkCoord(chunkX), Utils.mapToCenterOreChunkCoord(chunkZ));
    }

    public UpdateResult putOreVein(OreVeinPosition oreVeinPosition) {
        ChunkCoordIntPair key = this.getOreVeinKey(oreVeinPosition.chunkX, oreVeinPosition.chunkZ);
        if (!this.oreChunks.containsKey(key)) {
            this.oreChunks.put(key, oreVeinPosition);
            this.changedOrNewOreChunks.add(key);
            return UpdateResult.New;
        }
        OreVeinPosition storedOreVeinPosition = this.oreChunks.get(key);
        if (storedOreVeinPosition.veinType != oreVeinPosition.veinType) {
            this.oreChunks.put(key, oreVeinPosition.joinDepletedState(storedOreVeinPosition));
            this.changedOrNewOreChunks.add(key);
            return UpdateResult.New;
        }
        return UpdateResult.AlreadyKnown;
    }

    public void toggleOreVein(int chunkX, int chunkZ) {
        ChunkCoordIntPair key = this.getOreVeinKey(chunkX, chunkZ);
        if (this.oreChunks.containsKey(key)) {
            this.oreChunks.get(key).toggleDepleted();
            this.changedOrNewOreChunks.add(key);
        }
    }

    public OreVeinPosition getOreVein(int chunkX, int chunkZ) {
        ChunkCoordIntPair key = this.getOreVeinKey(chunkX, chunkZ);
        return this.oreChunks.getOrDefault(key, new OreVeinPosition(this.dimensionId, chunkX, chunkZ, VeinType.NO_VEIN, true));
    }

    private ChunkCoordIntPair getUndergroundFluidKey(int chunkX, int chunkZ) {
        return new ChunkCoordIntPair(Utils.mapToCornerUndergroundFluidChunkCoord(chunkX), Utils.mapToCornerUndergroundFluidChunkCoord(chunkZ));
    }

    public UpdateResult putUndergroundFluid(UndergroundFluidPosition undergroundFluid) {
        ChunkCoordIntPair key = this.getUndergroundFluidKey(undergroundFluid.chunkX, undergroundFluid.chunkZ);
        if (!this.undergroundFluids.containsKey(key)) {
            this.changedOrNewUndergroundFluids.add(key);
            this.undergroundFluids.put(key, undergroundFluid);
            return UpdateResult.New;
        }
        if (!this.undergroundFluids.get(key).equals(undergroundFluid)) {
            this.changedOrNewUndergroundFluids.add(key);
            this.undergroundFluids.put(key, undergroundFluid);
            return UpdateResult.Updated;
        }
        return UpdateResult.AlreadyKnown;
    }

    public UndergroundFluidPosition getUndergroundFluid(int chunkX, int chunkZ) {
        ChunkCoordIntPair key = this.getUndergroundFluidKey(chunkX, chunkZ);
        return this.undergroundFluids.getOrDefault(key, UndergroundFluidPosition.getNotProspected(this.dimensionId, chunkX, chunkZ));
    }

    public Collection<OreVeinPosition> getAllOreVeins() {
        return this.oreChunks.values();
    }

    public Collection<UndergroundFluidPosition> getAllUndergroundFluids() {
        return this.undergroundFluids.values();
    }

    public static enum UpdateResult {
        AlreadyKnown,
        Updated,
        New;

    }
}

