/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.mixinplugin;

import com.google.common.io.Files;
import java.nio.file.Path;

public enum TargetedMod {
    VANILLA("Minecraft", "unused", true),
    GREGTECH("GregTech", "gregtech", true),
    JOURNEYMAP("JourneyMap", "journeymap-1.7.10", true),
    XAEROWORLDMAP("Xaero's World Map", "XaerosWorldMap", true),
    XAEROMINIMAP("Xaero's Minimap", "Xaeros_Minimap", true),
    TCNODETRACKER("TCNodeTracker", "tcnodetracker-1.7.10", true),
    BARTWORKS("Bartworks", "bartworks", false),
    GALACTICGREG("GalacticGreg", "GalacticGreg", false);

    public final String modName;
    public final String jarNamePrefixLowercase;
    public final boolean loadInDevelopment;

    private TargetedMod(String modName, String jarNamePrefix, boolean loadInDevelopment) {
        this.modName = modName;
        this.jarNamePrefixLowercase = jarNamePrefix.toLowerCase();
        this.loadInDevelopment = loadInDevelopment;
    }

    public boolean isMatchingJar(Path path) {
        String pathString = path.toString();
        String nameLowerCase = Files.getNameWithoutExtension((String)pathString).toLowerCase();
        String fileExtension = Files.getFileExtension((String)pathString);
        return nameLowerCase.startsWith(this.jarNamePrefixLowercase) && ("jar".equals(fileExtension) || "litemod".equals(fileExtension));
    }

    public String toString() {
        return "TargetedMod{modName='" + this.modName + '\'' + ", jarNamePrefixLowercase='" + this.jarNamePrefixLowercase + '\'' + '}';
    }
}

